/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.jrjackson.RubyHandler;
import java.io.IOException;
import java.util.HashMap;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;

public class JrParse {
    private final RubyHandler _handler;
    private final HashMap<JsonStreamContext, IRubyObject> _objectMap = new HashMap();
    private JsonStreamContext _deepestContext;

    public JrParse(RubyHandler handler) {
        this._handler = handler;
    }

    public void deserialize(JsonParser jp) throws IOException {
        try {
            while (jp.nextValue() != null) {
                this.handleRubyToken(jp);
            }
        }
        catch (IOException e) {
            this._handler.raiseError(e.getLocalizedMessage());
        }
    }

    private void addRubyValue(JsonStreamContext x) {
        JsonStreamContext px = x.getParent();
        IRubyObject dtarget = this._objectMap.get(this._deepestContext);
        if (px == null) {
            this._handler.addValue(dtarget);
            return;
        }
        IRubyObject value = this._objectMap.get(x);
        if (x.inArray()) {
            this._handler.arrayAppend((RubyArray)value, dtarget);
        } else if (x.inObject()) {
            this._handler.hashSet((RubyHash)value, this.getRubyHashKey(x), dtarget);
        } else {
            this._handler.addValue(value);
        }
    }

    private void addRubyValue(JsonStreamContext x, IRubyObject val) {
        if (x.inArray()) {
            RubyArray a = (RubyArray)this._objectMap.get(x);
            this._handler.arrayAppend(a, val);
        } else if (x.inObject()) {
            RubyHash h = (RubyHash)this._objectMap.get(x);
            this._handler.hashSet(h, this.getRubyHashKey(x), val);
        } else {
            this._handler.addValue(val);
        }
    }

    private IRubyObject getRubyHashKey(JsonStreamContext x) {
        String k = x.getCurrentName();
        if (k == null) {
            return this._handler.treatNull();
        }
        return this._handler.hashKey(k);
    }

    protected void handleRubyToken(JsonParser jp) throws IOException {
        JsonStreamContext cx = jp.getParsingContext();
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                this._deepestContext = cx;
                this._objectMap.put(cx, this._handler.hashStart());
                break;
            }
            case START_ARRAY: {
                this._deepestContext = cx;
                this._objectMap.put(cx, this._handler.arrayStart());
            }
            case FIELD_NAME: {
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                System.out.println("-------- VALUE_EMBEDDED_OBJECT ????????? --------");
                System.out.println(jp.getEmbeddedObject());
                break;
            }
            case VALUE_STRING: {
                this.addRubyValue(cx, this._handler.treatString(jp));
                break;
            }
            case VALUE_NUMBER_INT: {
                this.addRubyValue(cx, this._handler.treatInt(jp));
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.addRubyValue(cx, this._handler.treatFloat(jp));
                break;
            }
            case VALUE_TRUE: {
                this.addRubyValue(cx, this._handler.trueValue());
                break;
            }
            case VALUE_FALSE: {
                this.addRubyValue(cx, this._handler.falseValue());
                break;
            }
            case VALUE_NULL: {
                this.addRubyValue(cx, this._handler.treatNull());
                break;
            }
            case END_ARRAY: {
                this._handler.arrayEnd();
                this.addRubyValue(cx);
                this._deepestContext = cx;
                break;
            }
            case END_OBJECT: {
                this._handler.hashEnd();
                this.addRubyValue(cx);
                this._deepestContext = cx;
            }
        }
    }
}

