/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.representations.BasicBlock;

public abstract class DataFlowProblem<T extends DataFlowProblem<T, U>, U extends FlowGraphNode<T, U>> {
    public final DF_Direction direction;
    protected List<U> flowGraphNodes;
    protected FullInterpreterContext fic;
    private int nextVariableId = -1;
    private Map<BasicBlock, U> basicBlockToFlowGraph;

    public DataFlowProblem(DF_Direction direction) {
        this.direction = direction;
    }

    public abstract U buildFlowGraphNode(BasicBlock var1);

    public abstract String getName();

    public boolean isEmpty() {
        return false;
    }

    public DF_Direction getFlowDirection() {
        return this.direction;
    }

    public void setup(FullInterpreterContext fic) {
        this.fic = fic;
        this.buildFlowGraph();
    }

    public FullInterpreterContext getFIC() {
        return this.fic;
    }

    public void compute_MOP_Solution() {
        if (this.isEmpty()) {
            return;
        }
        LinkedList<U> workList = this.generateWorkList();
        int numNodes = this.fic.getCFG().getMaxNodeID();
        BitSet bbSet = new BitSet(1 + numNodes);
        bbSet.flip(0, numNodes);
        while (!workList.isEmpty()) {
            ((FlowGraphNode)workList.removeFirst()).computeDataFlowInfo(workList, bbSet);
        }
    }

    protected LinkedList<U> generateWorkList() {
        Iterator<BasicBlock> it;
        LinkedList<U> wl = new LinkedList<U>();
        Iterator<BasicBlock> iterator = it = this.direction == DF_Direction.FORWARD ? this.fic.getCFG().getReversePostOrderTraverser() : this.fic.getCFG().getPostOrderTraverser();
        while (it.hasNext()) {
            wl.add(this.getFlowGraphNode(it.next()));
        }
        return wl;
    }

    public int getDFVarsCount() {
        return this.nextVariableId + 1;
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("----").append(this.getName()).append("----\n");
        buf.append("---- Data Flow Vars: ----\n");
        buf.append(this.getDataFlowVarsForOutput());
        buf.append("-------------------------\n");
        for (FlowGraphNode n : this.flowGraphNodes) {
            buf.append("DF State for BB ").append(n.basicBlock.getID()).append(":\n").append(n.toString());
        }
        return buf.toString();
    }

    public U getFlowGraphNode(BasicBlock bb) {
        return (U)((FlowGraphNode)this.basicBlockToFlowGraph.get(bb));
    }

    public U getEntryNode() {
        return this.getFlowGraphNode(this.fic.getCFG().getEntryBB());
    }

    public U getExitNode() {
        return this.getFlowGraphNode(this.fic.getCFG().getExitBB());
    }

    public int addDataFlowVar() {
        ++this.nextVariableId;
        return this.nextVariableId;
    }

    private void buildFlowGraph() {
        this.flowGraphNodes = new LinkedList<U>();
        this.basicBlockToFlowGraph = new HashMap<BasicBlock, U>();
        for (BasicBlock bb : this.fic.getCFG().getBasicBlocks()) {
            U fgNode = this.buildFlowGraphNode(bb);
            ((FlowGraphNode)fgNode).init();
            ((FlowGraphNode)fgNode).buildDataFlowVars();
            this.flowGraphNodes.add(fgNode);
            this.basicBlockToFlowGraph.put(bb, fgNode);
        }
    }

    public static enum DF_Direction {
        FORWARD,
        BACKWARD,
        BIDIRECTIONAL;

    }
}

