/*
 * Decompiled with CFR 0.152.
 */
package jnr.a64asm;

import jnr.a64asm.Ext;
import jnr.a64asm.Label;
import jnr.a64asm.Operand;
import jnr.a64asm.Register;

public class Mem
extends Operand {
    private final int base;
    private final int index;
    private final int shift;
    private final Ext extend;
    private final Label label;
    private final long target;
    private final long displacement;

    Mem(Register base, int size2) {
        this(base.index(), 255, 0, null, 0L, 0L, size2, null);
    }

    Mem(Register base, Ext extend2, int size2) {
        this(base.index(), 255, 0, null, 0L, 0L, size2, null);
    }

    Mem(Label label2, long displacement, int size2) {
        this(255, 255, 0, label2, 0L, displacement, size2, null);
    }

    Mem(Register base, long displacement, int size2) {
        this(base.index(), 255, 0, null, 0L, displacement, size2, null);
    }

    Mem(Register base, Register index2, int shift2, long displacement, int size2) {
        this(base.index(), index2.index(), shift2, null, 0L, displacement, size2, null);
    }

    Mem(Label label2, Register index2, int shift2, long disp, int ptrSize) {
        this(0, index2.index(), shift2, label2, 0L, disp, ptrSize, null);
    }

    Mem(long target2, long disp, int ptrSize) {
        this(255, 255, 0, null, target2, disp, ptrSize, null);
    }

    Mem(long target2, Register index2, int shift2, long disp, int ptrSize) {
        this(255, index2.index(), shift2, null, target2, disp, ptrSize, null);
    }

    private Mem(int base, int index2, int shift2, Label label2, long target2, long displacement, int size2, Ext extend2) {
        super(2, size2);
        assert (shift2 <= 3);
        this.base = base;
        this.index = index2;
        this.shift = shift2;
        this.label = label2;
        this.target = target2;
        this.displacement = displacement;
        this.extend = extend2;
    }

    public final boolean hasLabel() {
        return this.label != null;
    }

    public final boolean hasBase() {
        return this.base != 255;
    }

    boolean hasIndex() {
        return this.index != 255;
    }

    public final int base() {
        return this.base;
    }

    public final long displacement() {
        return this.displacement;
    }

    public final int index() {
        return this.index;
    }

    public final Label label() {
        return this.label;
    }

    public final int shift() {
        return this.shift;
    }

    public final long target() {
        return this.target;
    }
}

