/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class FilterReturn
extends Transform {
    private final MethodHandle function;
    public static final String FILTER_FUNCTION_JAVA = "<filter function>";

    public FilterReturn(MethodHandle function) {
        this.function = function;
    }

    @Override
    public MethodHandle up(MethodHandle target2) {
        return MethodHandles.filterReturnValue(target2, this.function);
    }

    @Override
    public MethodType down(MethodType type2) {
        int count2 = this.function.type().parameterCount();
        switch (count2) {
            case 0: {
                return type2.changeReturnType(Void.TYPE);
            }
            case 1: {
                return type2.changeReturnType((Class<?>)this.function.type().parameterType(0));
            }
        }
        throw new InvalidTransformException("return filter " + this.function + " does not accept zero or one argument");
    }

    @Override
    public String toString() {
        return "filter return with " + this.function;
    }

    @Override
    public String toJava(MethodType incoming) {
        return "handle = MethodHandles.filterReturnValue(handle, <filter function>);";
    }
}

