/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.shared.common.error.StandardException;

public abstract class GenericConglomerateController
extends GenericController
implements ConglomerateController {
    @Override
    public void close() throws StandardException {
        super.close();
        if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
            this.open_conglom.getXactMgr().closeMe(this);
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        super.close();
        if (!this.open_conglom.getHold() || closeHeldScan) {
            if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
                this.open_conglom.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(RowLocation loc) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException((String)"XSCH6.S", (Object[])new Object[]{this.open_conglom.getConglomerate().getId()});
            }
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        this.open_conglom.lockPositionForWrite(pos, true);
        boolean ret_val = true;
        if (pos.current_page.isDeletedAtSlot(pos.current_slot)) {
            ret_val = false;
        } else {
            pos.current_page.deleteAtSlot(pos.current_slot, true, null);
            if (pos.current_page.shouldReclaimSpace(pos.current_page.getPageNumber() == 1L ? 1 : 0, pos.current_slot)) {
                this.queueDeletePostCommitWork(pos);
            }
        }
        pos.current_page.unlatch();
        return ret_val;
    }

    @Override
    public boolean fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        boolean ret_val;
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException((String)"XSCH6.S", (Object[])new Object[]{this.open_conglom.getConglomerate().getId()});
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException((String)"XSCH5.S", (Object[])new Object[]{invalidColumn, this.open_conglom.getFormatIds().length});
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(pos, true);
        } else {
            this.open_conglom.lockPositionForRead(pos, null, false, true);
        }
        if (pos.current_page == null) {
            return false;
        }
        boolean bl = ret_val = pos.current_page.fetchFromSlot(pos.current_rh, pos.current_slot, row, new FetchDescriptor(row.length, validColumns, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(pos);
        }
        pos.current_page.unlatch();
        return ret_val;
    }

    @Override
    public boolean fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean waitForLock) throws StandardException {
        boolean ret_val;
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException((String)"XSCH6.S", (Object[])new Object[]{this.open_conglom.getConglomerate().getId()});
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException((String)"XSCH5.S", (Object[])new Object[]{invalidColumn, this.open_conglom.getFormatIds().length});
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(pos, waitForLock);
        } else {
            this.open_conglom.lockPositionForRead(pos, null, false, waitForLock);
        }
        if (pos.current_page == null) {
            return false;
        }
        boolean bl = ret_val = pos.current_page.fetchFromSlot(pos.current_rh, pos.current_slot, row, new FetchDescriptor(row.length, validColumns, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(pos);
        }
        pos.current_page.unlatch();
        return ret_val;
    }

    @Override
    public boolean replace(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException((String)"XSCH6.S", (Object[])new Object[]{this.open_conglom.getConglomerate().getId()});
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException((String)"XSCH5.S", (Object[])new Object[]{invalidColumn, this.open_conglom.getFormatIds().length});
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        this.open_conglom.lockPositionForWrite(pos, true);
        boolean ret_val = true;
        if (pos.current_page.isDeletedAtSlot(pos.current_slot)) {
            ret_val = false;
        } else {
            pos.current_page.updateAtSlot(pos.current_slot, row, validColumns);
        }
        pos.current_page.unlatch();
        return ret_val;
    }
}

