/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.agg.Aggregator;

public class VarPAggregator<V extends Number>
implements Aggregator<V, Double, VarPAggregator<V>>,
Externalizable {
    private static final long serialVersionUID = 239794626052067761L;
    protected Sums sums;
    protected int count;

    @Override
    public void init() {
        this.sums = new Sums();
        this.count = 0;
    }

    @Override
    public void accumulate(V value) {
        double itemd = ((Number)value).doubleValue();
        this.sums.x += itemd;
        this.sums.x2 += Math.pow(itemd, 2.0);
        ++this.count;
    }

    @Override
    public void merge(VarPAggregator<V> otherAggregator) {
        this.sums.x += otherAggregator.sums.x;
        this.sums.x2 += otherAggregator.sums.x2;
        this.count += otherAggregator.count;
    }

    protected Double computeVar() {
        if (this.count == 0) {
            return null;
        }
        return this.sums.x2 / (double)this.count - Math.pow(this.sums.x / (double)this.count, 2.0);
    }

    @Override
    public Double terminate() {
        return this.computeVar();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.count = in.readInt();
        this.sums = (Sums)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.count);
        out.writeObject(this.sums);
    }

    public static class Sums {
        double x = 0.0;
        double x2 = 0.0;
    }
}

