/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CachedValueNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReplaceNodeVisitor;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ConditionalNode
extends ValueNode {
    private CachedValueNode caseOperand;
    private ValueNodeList testConditions;
    private ValueNodeList thenElseList;

    ConditionalNode(CachedValueNode caseOperand, ValueNodeList testConditions, ValueNodeList thenElseList, ContextManager cm) {
        super(cm);
        this.caseOperand = caseOperand;
        this.testConditions = testConditions;
        this.thenElseList = thenElseList;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.testConditions != null) {
            this.printLabel(depth, "testConditions: ");
            this.testConditions.treePrint(depth + 1);
        }
        if (this.thenElseList != null) {
            this.printLabel(depth, "thenElseList: ");
            this.thenElseList.treePrint(depth + 1);
        }
    }

    private void recastNullNodes(DataTypeDescriptor castType, FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        castType = castType.getNullabilityType(true);
        for (int i = 0; i < this.thenElseList.size(); ++i) {
            ValueNode vn = (ValueNode)this.thenElseList.elementAt(i);
            if (!(vn instanceof UntypedNullConstantNode)) continue;
            CastNode cast = new CastNode(vn, castType, this.getContextManager());
            cast.bindExpression(fromList, subqueryList, aggregates);
            this.thenElseList.setElementAt(cast, i);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        int previousReliability = this.orReliability(16384);
        ValueNodeList caseOperandParameters = this.bindCaseOperand(cc, fromList, subqueryList, aggregates);
        this.testConditions.bindExpression(fromList, subqueryList, aggregates);
        if (caseOperandParameters != null) {
            for (Object vn : caseOperandParameters) {
                caseOperandParameters.comparable((ValueNode)vn);
                this.testConditions.accept(new ReplaceNodeVisitor((Visitable)vn, this.caseOperand));
            }
            this.caseOperand.setType(caseOperandParameters.getDominantTypeServices());
        }
        this.thenElseList.bindExpression(fromList, subqueryList, aggregates);
        DataTypeDescriptor nullType = this.thenElseList.getTypeServices();
        if (nullType == null) {
            throw StandardException.newException((String)"42X87", (Object[])new Object[0]);
        }
        this.recastNullNodes(nullType, fromList, subqueryList, aggregates);
        this.setType(this.thenElseList.getDominantTypeServices());
        this.testConditions.setParameterDescriptor(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        for (Object testCondition : this.testConditions) {
            if (((ValueNode)testCondition).getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) continue;
            throw StandardException.newException((String)"42X88", (Object[])new Object[0]);
        }
        this.thenElseList.setParameterDescriptor(this.getTypeServices());
        ClassInspector cu = this.getClassFactory().getClassInspector();
        for (ValueNode expr : this.thenElseList) {
            DataTypeDescriptor dtd = expr.getTypeServices();
            String javaTypeName = dtd.getTypeId().getCorrespondingJavaTypeName();
            String resultJavaTypeName = this.getTypeId().getCorrespondingJavaTypeName();
            if (dtd.comparable(this.getTypeServices(), false, this.getClassFactory()) || cu.assignableTo(javaTypeName, resultJavaTypeName) || cu.assignableTo(resultJavaTypeName, javaTypeName)) continue;
            throw StandardException.newException((String)"42X89", (Object[])new Object[]{dtd.getTypeId().getSQLTypeName(), this.getTypeId().getSQLTypeName()});
        }
        this.setNullability(this.thenElseList.isNullable());
        TypeId condTypeId = this.getTypeId();
        for (int i = 0; i < this.thenElseList.size(); ++i) {
            ValueNode expr = (ValueNode)this.thenElseList.elementAt(i);
            if (expr.getTypeId().typePrecedence() == condTypeId.typePrecedence()) continue;
            ValueNode cast = new CastNode(expr, this.getTypeServices(), this.getContextManager());
            cast = ((ValueNode)cast).bindExpression(fromList, subqueryList, aggregates);
            this.thenElseList.setElementAt(cast, i);
        }
        cc.setReliability(previousReliability);
        return this;
    }

    private ValueNodeList bindCaseOperand(CompilerContext cc, FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        ValueNodeList replacements = null;
        if (this.caseOperand != null) {
            int previousReliability = this.orReliability(22528);
            if (this.caseOperand.requiresTypeFromContext()) {
                replacements = new ValueNodeList(this.getContextManager());
                this.testConditions.accept(new ReplaceCaseOperandVisitor(replacements));
            }
            this.caseOperand = (CachedValueNode)this.caseOperand.bindExpression(fromList, subqueryList, aggregates);
            cc.setReliability(previousReliability);
        }
        return replacements;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.testConditions.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.thenElseList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = this.testConditions.categorize(referencedTabs, simplePredsOnly);
        pushable = this.thenElseList.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.testConditions = this.testConditions.remapColumnReferencesToExpressions();
        this.thenElseList = this.thenElseList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.testConditions.isConstantExpression() && this.thenElseList.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.testConditions.constantExpression(whereClause) && this.thenElseList.constantExpression(whereClause);
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        this.thenElseList.eliminateNots(underNotNode);
        this.testConditions.eliminateNots(false);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int i;
        SanityManager.ASSERT((this.testConditions.size() > 0 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.thenElseList.size() == this.testConditions.size() + 1 ? 1 : 0) != 0);
        for (i = 0; i < this.testConditions.size(); ++i) {
            ((ValueNode)this.testConditions.elementAt(i)).generateExpression(acb, mb);
            mb.cast("org.apache.derby.iapi.types.BooleanDataValue");
            mb.push(true);
            mb.callMethod((short)185, null, "equals", "boolean", 1);
            mb.conditionalIf();
            ((ValueNode)this.thenElseList.elementAt(i)).generateExpression(acb, mb);
            mb.startElseCode();
        }
        ((ValueNode)this.thenElseList.elementAt(this.thenElseList.size() - 1)).generateExpression(acb, mb);
        for (i = 0; i < this.testConditions.size(); ++i) {
            mb.completeConditional();
        }
        if (this.caseOperand != null) {
            this.caseOperand.generateClearField(mb);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.testConditions != null) {
            this.testConditions = (ValueNodeList)this.testConditions.accept(v);
        }
        if (this.thenElseList != null) {
            this.thenElseList = (ValueNodeList)this.thenElseList.accept(v);
        }
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            ConditionalNode other = (ConditionalNode)o;
            return this.testConditions.isEquivalent(other.testConditions) && this.thenElseList.isEquivalent(other.thenElseList);
        }
        return false;
    }

    private class ReplaceCaseOperandVisitor
    implements Visitor {
        private final ValueNodeList replacements;

        private ReplaceCaseOperandVisitor(ValueNodeList replacements) {
            this.replacements = replacements;
        }

        @Override
        public Visitable visit(Visitable node) throws StandardException {
            if (node == ConditionalNode.this.caseOperand) {
                ParameterNode pn = new ParameterNode(0, null, ConditionalNode.this.getContextManager());
                this.replacements.addElement(pn);
                return pn;
            }
            return node;
        }

        @Override
        public boolean visitChildrenFirst(Visitable node) {
            return false;
        }

        @Override
        public boolean stopTraversal() {
            return false;
        }

        @Override
        public boolean skipChildren(Visitable node) throws StandardException {
            return false;
        }
    }
}

