/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineCallableStatement;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EmbedCallableStatement
extends EmbedPreparedStatement
implements EngineCallableStatement {
    private boolean hasReturnOutputParameter;
    protected boolean wasNull;

    public EmbedCallableStatement(EmbedConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        ParameterValueSet pvs = this.getParms();
        this.hasReturnOutputParameter = pvs.hasReturnOutputParameter();
    }

    @Override
    protected void checkRequiresCallableStatement(Activation activation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            try {
                this.getParms().validate();
            }
            catch (StandardException e) {
                throw EmbedResultSet.noStateChangeException(e);
            }
            boolean execResult = super.executeStatement(a, executeQuery, executeUpdate && !this.hasReturnOutputParameter);
            ParameterValueSet pvs = this.getParms();
            if (this.hasReturnOutputParameter) {
                SanityManager.ASSERT((this.results != null ? 1 : 0) != 0, (String)"null results even though we are supposed to have a return parameter");
                boolean gotRow = this.results.next();
                SanityManager.ASSERT((boolean)gotRow, (String)"the return resultSet didn't have any rows");
                try {
                    DataValueDescriptor returnValue = pvs.getReturnValueForSet();
                    returnValue.setValueFromResultSet(this.results, 1, true);
                }
                catch (StandardException e) {
                    throw EmbedResultSet.noStateChangeException(e);
                }
                finally {
                    this.results.close();
                    this.results = null;
                }
                execResult = false;
            }
            return execResult;
        }
    }

    @Override
    public final void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, -1);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public final void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw EmbedCallableStatement.newSQLException("XJ044.S", scale);
        }
        try {
            this.getParms().registerOutParameter(parameterIndex - 1, sqlType, scale);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            String v = this.getParms().getParameterForGet(parameterIndex - 1).getString();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            boolean v = param.getBoolean();
            this.wasNull = !v && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            byte b = param.getByte();
            this.wasNull = b == 0 && param.isNull();
            return b;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            short s = param.getShort();
            this.wasNull = s == 0 && param.isNull();
            return s;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            int v = param.getInt();
            this.wasNull = v == 0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            long v = param.getLong();
            this.wasNull = v == 0L && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public final BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dvd = this.getParms().getParameterForGet(parameterIndex - 1);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dvd);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public final BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal v = this.getBigDecimal(parameterIndex);
        if (v != null) {
            v = v.setScale(scale, 5);
        }
        return v;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            float v = param.getFloat();
            this.wasNull = (double)v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
            double v = param.getDouble();
            this.wasNull = v == 0.0 && param.isNull();
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            byte[] v = this.getParms().getParameterForGet(parameterIndex - 1).getBytes();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            Date v = this.getParms().getParameterForGet(parameterIndex - 1).getDate(cal);
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            Time v = this.getParms().getParameterForGet(parameterIndex - 1).getTime(cal);
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            Timestamp v = this.getParms().getParameterForGet(parameterIndex - 1).getTimestamp(cal);
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, this.getCal());
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, this.getCal());
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, this.getCal());
    }

    @Override
    public final Object getObject(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            Object v = this.getParms().getParameterForGet(parameterIndex - 1).getObject();
            this.wasNull = v == null;
            return v;
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e);
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        Object o = this.getObject(parameterIndex);
        if (o == null || o instanceof Blob) {
            return (Blob)o;
        }
        throw EmbedCallableStatement.newSQLException("22005", Blob.class.getName(), Util.typeName(this.getParameterJDBCType(parameterIndex)));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        Object o = this.getObject(parameterIndex);
        if (o == null || o instanceof Clob) {
            return (Clob)o;
        }
        throw EmbedCallableStatement.newSQLException("22005", Clob.class.getName(), Util.typeName(this.getParameterJDBCType(parameterIndex)));
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet pvs = this.getParms();
        int numberOfParameters = pvs.getParameterCount();
        block4: for (int j = 1; j <= numberOfParameters; ++j) {
            switch (pvs.getParameterMode(j)) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 4: {
                    throw EmbedCallableStatement.newSQLException("XJ04C.S", new Object[0]);
                }
            }
        }
        super.addBatch();
    }

    @Override
    public final Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(i);
    }

    @Override
    public final Ref getRef(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Ref getRef(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Blob getBlob(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Clob getClob(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNull(String parameterName, int sqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final boolean getBoolean(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setByte(String parameterName, byte x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final byte getByte(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setShort(String parameterName, short x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final short getShort(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setInt(String parameterName, int x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final int getInt(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setLong(String parameterName, long x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final long getLong(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setFloat(String parameterName, float x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final float getFloat(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDouble(String parameterName, double x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final double getDouble(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setString(String parameterName, String x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getString(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final byte[] getBytes(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDate(String parameterName, Date x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Date getDate(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTime(String parameterName, Time x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Time getTime(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Object getObject(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(parameterName);
    }

    @Override
    public final void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setObject(String parameterName, Object x) throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkStatus();
        switch (this.getParms().getParameterMode(parameterIndex)) {
            case 0: 
            case 1: {
                throw EmbedCallableStatement.newSQLException("XCL26.S", Integer.toString(parameterIndex));
            }
        }
        Reader reader = null;
        int paramType = this.getParameterJDBCType(parameterIndex);
        switch (paramType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Object syncObject;
                boolean pushStack = false;
                Object object = syncObject = this.getConnectionSynchronization();
                synchronized (object) {
                    try {
                        StringDataValue param = (StringDataValue)this.getParms().getParameterForGet(parameterIndex - 1);
                        if (param.isNull()) {
                            break;
                        }
                        pushStack = true;
                        this.setupContextStack();
                        if (param.hasStream()) {
                            CharacterStreamDescriptor csd = param.getStreamWithDescriptor();
                            reader = new UTF8Reader(csd, this, syncObject);
                        } else {
                            reader = new StringReader(param.getString());
                        }
                    }
                    catch (Throwable t) {
                        throw EmbedResultSet.noStateChangeException(t);
                    }
                    finally {
                        if (pushStack) {
                            this.restoreContextStack();
                        }
                    }
                    break;
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream is = this.getBinaryStream(parameterIndex);
                    if (is == null) break;
                    reader = new InputStreamReader(is, "UTF-16BE");
                    break;
                }
                catch (UnsupportedEncodingException uee) {
                    throw EmbedCallableStatement.newSQLException(uee.getMessage(), new Object[0]);
                }
            }
            default: {
                throw EmbedCallableStatement.newSQLException("22005", "java.io.Reader", Util.typeName(paramType));
            }
        }
        this.wasNull = reader == null;
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getBinaryStream(int parameterIndex) throws SQLException {
        int paramType = this.getParameterJDBCType(parameterIndex);
        switch (paramType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw EmbedCallableStatement.newSQLException("22005", "java.io.InputStream", Util.typeName(paramType));
            }
        }
        boolean pushStack = false;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
                this.wasNull = param.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                pushStack = true;
                this.setupContextStack();
                InputStream stream = param.hasStream() ? new BinaryToRawStream(param.getStream(), param) : new ByteArrayInputStream(param.getBytes());
                InputStream inputStream = stream;
                return inputStream;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final Reader getCharacterStream(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getNString(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getNString(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBlob(String parameterName, Blob x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setClob(String parameterName, Clob x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final RowId getRowId(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final RowId getRowId(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setRowId(String parameterName, RowId x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNString(String parameterName, String value) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(String parameterName, NClob value) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final NClob getNClob(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final NClob getNClob(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLXML getSQLXML(String parametername) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw Util.notImplemented("setAsciiStream(String,InputStream)");
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw Util.notImplemented("setBinaryStream(String,InputStream)");
    }

    @Override
    public final void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw Util.notImplemented("setBlob(String,InputStream)");
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw Util.notImplemented("setCharacterStream(String,Reader)");
    }

    @Override
    public final void setClob(String parameterName, Reader reader) throws SQLException {
        throw Util.notImplemented("setClob(String,Reader)");
    }

    @Override
    public final void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Util.notImplemented("setNCharacterStream(String,Reader)");
    }

    @Override
    public final void setNClob(String parameterName, Reader reader) throws SQLException {
        throw Util.notImplemented("setNClob(String,Reader)");
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        this.checkStatus();
        if (type == null) {
            throw this.mismatchException("NULL", parameterIndex);
        }
        Object retval = String.class.equals(type) ? this.getString(parameterIndex) : (BigDecimal.class.equals(type) ? this.getBigDecimal(parameterIndex) : (Boolean.class.equals(type) ? Boolean.valueOf(this.getBoolean(parameterIndex)) : (Byte.class.equals(type) ? Byte.valueOf(this.getByte(parameterIndex)) : (Short.class.equals(type) ? Short.valueOf(this.getShort(parameterIndex)) : (Integer.class.equals(type) ? Integer.valueOf(this.getInt(parameterIndex)) : (Long.class.equals(type) ? Long.valueOf(this.getLong(parameterIndex)) : (Float.class.equals(type) ? Float.valueOf(this.getFloat(parameterIndex)) : (Double.class.equals(type) ? Double.valueOf(this.getDouble(parameterIndex)) : (Date.class.equals(type) ? this.getDate(parameterIndex) : (Time.class.equals(type) ? this.getTime(parameterIndex) : (Timestamp.class.equals(type) ? this.getTimestamp(parameterIndex) : (Blob.class.equals(type) ? this.getBlob(parameterIndex) : (Clob.class.equals(type) ? this.getClob(parameterIndex) : (type.isArray() && type.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(parameterIndex) : this.getObject(parameterIndex)))))))))))))));
        if (this.wasNull()) {
            retval = null;
        }
        if (retval == null || type.isInstance(retval)) {
            return type.cast(retval);
        }
        throw this.mismatchException(type.getName(), parameterIndex);
    }

    private SQLException mismatchException(String targetTypeName, int parameterIndex) throws SQLException {
        String sourceTypeName = this.getParameterMetaData().getParameterTypeName(parameterIndex);
        return EmbedCallableStatement.newSQLException("22005", targetTypeName, sourceTypeName);
    }

    @Override
    public final <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Util.notImplemented();
    }
}

