/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public abstract class SNMPv3SecurityModel
implements SecurityModel {
    protected OctetString localEngineID;
    protected CounterSupport counterSupport = CounterSupport.getInstance();

    public OctetString getLocalEngineID() {
        return this.localEngineID;
    }

    protected static byte[] buildWholeMessage(Integer32 snmpVersion, byte[] scopedPdu, byte[] globalData, SecurityParameters securityParameters) throws IOException {
        int length = snmpVersion.getBERLength() + globalData.length + securityParameters.getBERLength() + scopedPdu.length;
        int totalLength = BER.getBERLengthOfLength(length) + length + 1;
        ByteArrayOutputStream os = new ByteArrayOutputStream(totalLength);
        BER.encodeHeader(os, 48, length);
        snmpVersion.encodeBER(os);
        os.write(globalData);
        securityParameters.encodeBER(os);
        os.write(scopedPdu);
        int secParamsPos = 1 + snmpVersion.getBERLength() + BER.getBERLengthOfLength(length) + globalData.length;
        securityParameters.setSecurityParametersPosition(secParamsPos);
        return os.toByteArray();
    }

    protected static byte[] buildMessageBuffer(BERInputStream scopedPDU) throws IOException {
        int read;
        scopedPDU.mark(16);
        int readLengthBytes = (int)scopedPDU.getPosition();
        BER.MutableByte mutableByte = new BER.MutableByte();
        int length = BER.decodeHeader(scopedPDU, mutableByte);
        readLengthBytes = (int)scopedPDU.getPosition() - readLengthBytes;
        byte[] buf = new byte[length + readLengthBytes];
        scopedPDU.reset();
        int avail = scopedPDU.available();
        for (int offset = 0; offset < buf.length && avail > 0 && (read = scopedPDU.read(buf, offset, buf.length - offset)) >= 0; offset += read) {
        }
        return buf;
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    public void setCounterSupport(CounterSupport counterSupport) {
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
    }
}

