/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.snmp4j.TransportStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.transport.TransportType;

public interface TransportMapping<A extends Address>
extends Closeable {
    public Class<? extends Address> getSupportedAddressClass();

    default public Set<Class<? extends Address>> getSupportedAddressClasses() {
        return Collections.singleton(this.getSupportedAddressClass());
    }

    default public boolean isAddressSupported(Address addressType) {
        return this.isAddressSupported(addressType, false);
    }

    default public boolean isAddressSupported(Address addressType, boolean exactMatch) {
        if (exactMatch) {
            return this.getSupportedAddressClass().equals(addressType.getClass());
        }
        for (Class<Address> addressClass : this.getSupportedAddressClasses()) {
            if (!addressClass.isInstance(addressType)) continue;
            return true;
        }
        return false;
    }

    public A getListenAddress();

    public void sendMessage(A var1, byte[] var2, TransportStateReference var3, long var4, int var6) throws IOException;

    public void addTransportListener(TransportListener var1);

    public void removeTransportListener(TransportListener var1);

    @Override
    public void close() throws IOException;

    public void listen() throws IOException;

    public boolean isListening();

    public int getMaxInboundMessageSize();

    default public int getMaxOutboundMessageSize() {
        return this.getMaxInboundMessageSize();
    }

    default public TransportType getSupportedTransportType() {
        return TransportType.any;
    }
}

