/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.Collections;
import java.util.List;
import org.logstash.settings.BaseSetting;

public class SettingString
extends BaseSetting<String> {
    private List<String> possibleStrings = Collections.emptyList();

    public SettingString(String name, String defaultValue, boolean strict, List<String> possibleStrings) {
        super(name, strict, SettingString.noValidator());
        this.possibleStrings = possibleStrings;
        this.defaultValue = defaultValue;
        if (strict) {
            SettingString.staticValidate(defaultValue, possibleStrings, name);
        }
    }

    public SettingString(String name, String defaultValue) {
        this(name, defaultValue, true, Collections.emptyList());
    }

    public SettingString(String name, String defaultValue, boolean strict) {
        this(name, defaultValue, strict, Collections.emptyList());
    }

    @Override
    public void validate(String input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Setting \"%s\" must be a String. Received:  (NilClass)", this.getName()));
        }
        SettingString.staticValidate(input, this.possibleStrings, this.getName());
    }

    private static void staticValidate(String input, List<String> possibleStrings, String name) {
        if (!possibleStrings.isEmpty() && !possibleStrings.contains(input)) {
            throw new IllegalArgumentException(String.format("Invalid value \"%s: %s\" . Options are: %s", name, input, possibleStrings));
        }
    }
}

