/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import java.util.Locale;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.logstash.RubyUtil;
import org.logstash.log.DeprecationLoggerExt;
import org.logstash.log.SlowLoggerExt;

@JRubyModule(name={"Loggable"})
public final class LoggableExt {
    private LoggableExt() {
    }

    @JRubyMethod(module=true)
    public static RubyModule included(ThreadContext context, IRubyObject recv, IRubyObject clazz) {
        RubyModule klass = (RubyModule)clazz;
        klass.defineAnnotatedMethods(ClassMethods.class);
        return klass;
    }

    @JRubyMethod
    public static IRubyObject logger(ThreadContext context, IRubyObject self) {
        return self.getSingletonClass().callMethod(context, "logger");
    }

    @JRubyMethod(name={"slow_logger"}, required=4)
    public static IRubyObject slowLogger(ThreadContext context, IRubyObject self, IRubyObject[] args) {
        return self.getSingletonClass().callMethod(context, "slow_logger", args);
    }

    @JRubyMethod(name={"deprecation_logger"})
    public static IRubyObject deprecationLogger(ThreadContext context, IRubyObject self) {
        return self.getSingletonClass().callMethod(context, "deprecation_logger");
    }

    private static String log4jName(RubyModule self) {
        String name;
        if (self.getBaseName() == null) {
            RubyModule real = self;
            if (self instanceof RubyClass) {
                real = ((RubyClass)self).getRealClass();
            }
            name = real.getName();
        } else {
            name = self.getName();
        }
        return name.replace("::", ".").toLowerCase(Locale.ENGLISH);
    }

    public static final class ClassMethods {
        private ClassMethods() {
        }

        @JRubyMethod(meta=true)
        public static IRubyObject logger(ThreadContext context, IRubyObject self) {
            InstanceVariables instanceVariables = self instanceof RubyClass ? ((RubyClass)self).getRealClass().getInstanceVariables() : self.getInstanceVariables();
            IRubyObject logger = instanceVariables.getInstanceVariable("logger");
            if (logger == null || logger.isNil()) {
                String loggerName = LoggableExt.log4jName((RubyModule)self);
                logger = RubyUtil.LOGGER.callMethod(context, "new", (IRubyObject)context.runtime.newString(loggerName));
                instanceVariables.setInstanceVariable("logger", logger);
            }
            return logger;
        }

        @JRubyMethod(name={"slow_logger"}, required=4, meta=true)
        public static SlowLoggerExt slowLogger(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            InstanceVariables instanceVariables = self.getInstanceVariables();
            Object logger = instanceVariables.getInstanceVariable("slow_logger");
            if (logger == null || logger.isNil()) {
                String loggerName = LoggableExt.log4jName((RubyModule)self);
                logger = new SlowLoggerExt(context.runtime, RubyUtil.SLOW_LOGGER, loggerName, SlowLoggerExt.toLong(args[0]), SlowLoggerExt.toLong(args[1]), SlowLoggerExt.toLong(args[2]), SlowLoggerExt.toLong(args[3]));
                instanceVariables.setInstanceVariable("slow_logger", logger);
            }
            return (SlowLoggerExt)((Object)logger);
        }

        @JRubyMethod(name={"deprecation_logger"}, meta=true)
        public static IRubyObject deprecationLogger(ThreadContext context, IRubyObject self) {
            InstanceVariables instanceVariables = self instanceof RubyClass ? ((RubyClass)self).getRealClass().getInstanceVariables() : self.getInstanceVariables();
            Object logger = instanceVariables.getInstanceVariable("deprecation_logger");
            if (logger == null || logger.isNil()) {
                String loggerName = LoggableExt.log4jName((RubyModule)self);
                logger = new DeprecationLoggerExt(context.runtime, RubyUtil.DEPRECATION_LOGGER, loggerName);
                instanceVariables.setInstanceVariable("deprecation_logger", logger);
            }
            return logger;
        }
    }
}

