/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph.algorithms;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.Vertex;

public class DepthFirst {
    public static Stream<Vertex> depthFirst(Graph g) {
        return DepthFirst.depthFirst(g.getRoots());
    }

    public static Stream<Vertex> reverseDepthFirst(Graph g) {
        return DepthFirst.reverseDepthFirst(g.getLeaves());
    }

    public static Stream<Vertex> depthFirst(Vertex v) {
        return DepthFirst.depthFirst(Collections.singleton(v));
    }

    public static Stream<Vertex> reverseDepthFirst(Vertex v) {
        return DepthFirst.reverseDepthFirst(Collections.singleton(v));
    }

    public static Stream<Vertex> depthFirst(Collection<Vertex> v) {
        return DepthFirst.streamify(new Traversal(v, false));
    }

    public static Stream<Vertex> reverseDepthFirst(Collection<Vertex> v) {
        return DepthFirst.streamify(new Traversal(v, true));
    }

    private static Stream<Vertex> streamify(Traversal t) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(t, 1), false);
    }

    public static class Traversal
    implements Iterator<Vertex> {
        private final Set<Vertex> visited = new HashSet<Vertex>();
        private final Deque<Vertex> pending;
        private final boolean reverse;

        Traversal(Collection<Vertex> initialVertices, boolean reverse) {
            this.reverse = reverse;
            this.pending = new ArrayDeque<Vertex>(initialVertices);
        }

        @Override
        public boolean hasNext() {
            return !this.pending.isEmpty();
        }

        @Override
        public Vertex next() {
            Vertex current = this.pending.removeFirst();
            this.visited.add(current);
            Stream<Vertex> next = this.reverse ? current.incomingVertices() : current.outgoingVertices();
            next.forEach(v -> {
                if (!this.visited.contains(v)) {
                    this.pending.add((Vertex)v);
                }
            });
            return current;
        }
    }
}

