/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private Expression threads = null;
    private StructuredQName modeName;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private boolean defaultedSelectExpression = true;
    private Mode mode;
    private String modeAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("mode")) {
                this.modeAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.defaultedSelectExpression = false;
                continue;
            }
            if (f.equals("saxon:threads") && atts.getURI(a).equals("http://saxon.sf.net/")) {
                String threadsAtt = Whitespace.trim(atts.getValue(a));
                this.threads = this.makeAttributeValueTemplate(threadsAtt);
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    this.compileWarning("saxon:threads - no multithreading takes place when compiling with trace enabled", "SXWN9012");
                    this.threads = new StringLiteral("0", (Container)this);
                    continue;
                }
                if ("EE".equals(this.getConfiguration().getEditionCode())) continue;
                this.compileWarning("saxon:threads - ignored when not running Saxon-EE", "SXWN9013");
                this.threads = new StringLiteral("0", (Container)this);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (this.modeAttribute.equals("#unnamed") && this.isXslt30Processor()) {
                this.modeName = Mode.UNNAMED_MODE_NAME;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeName = this.makeQName(this.modeAttribute);
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                    this.modeName = null;
                }
                catch (XPathException err) {
                    this.compileError("Mode name " + Err.wrap(this.modeAttribute) + " is not a valid QName", err.getErrorCodeQName());
                    this.modeName = null;
                }
            }
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        if (this.useCurrentMode) {
            if (this.iterateAxis((byte)0, new NameTest(1, 200, this.getNamePool())).next() == null) {
                this.issueWarning("Specifying mode=\"#current\" when not inside an xsl:template serves no useful purpose", this);
            }
        } else {
            if (this.modeName == null) {
                this.modeName = this.getContainingStylesheet().getDefaultMode();
            }
            this.mode = this.getCompilation().getStylesheetPackage().getRuleManager().getMode(this.modeName, true);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLSort || child instanceof XSLWithParam) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-templates", "XTSE0010");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates", "XTSE0010");
        }
        if (this.select == null) {
            int lineNr = this.getLineNumber();
            this.select = new AxisExpression(3, null);
            this.select.setLocationId(lineNr);
        }
        this.select = this.typeCheck("select", this.select);
        if (!this.getEffectiveVersion().equals(DecimalValue.THREE)) {
            try {
                RoleLocator role = new RoleLocator(4, "xsl:apply-templates/select", 0);
                role.setErrorCode("XTTE0520");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
    }

    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        SortKeyDefinition[] sortKeys = this.makeSortKeys(compilation, decl);
        if (sortKeys != null) {
            this.useTailRecursion = false;
        }
        assert (this.select != null);
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        this.compileSequenceConstructor(compilation, decl, this.iterateAxis((byte)3), true);
        RuleManager rm = compilation.getStylesheetPackage().getRuleManager();
        ApplyTemplates app = new ApplyTemplates(sortedSequence, this.useCurrentMode, this.useTailRecursion, this.defaultedSelectExpression, this.mode, rm, this.threads);
        app.setActualParameters(this.getWithParamInstructions(compilation, decl, false), this.getWithParamInstructions(compilation, decl, true));
        return app;
    }
}

