/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.TraceClausePull;
import net.sf.saxon.expr.flwor.TraceClausePush;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class TraceClause
extends Clause {
    private Clause target;
    private Container container;
    private NamespaceResolver nsResolver;

    public TraceClause(Clause target, NamespaceResolver nsResolver, Container container) {
        this.target = target;
        this.nsResolver = nsResolver;
        this.container = container;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public void setNamespaceResolver(NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
    }

    public int getClauseKey() {
        return 7;
    }

    public TraceClause copy() {
        return new TraceClause(this.target, this.nsResolver, this.container);
    }

    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new TraceClausePull(base, this, this.target, this.container);
    }

    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new TraceClausePush(destination, this, this.target, this.container);
    }

    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("trace");
        out.endElement();
    }

    public String toString() {
        return "trace";
    }
}

