/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.OperationResult;
import java.util.Objects;
import java.util.function.Consumer;

class OperationResultBase<T, E extends Exception>
implements OperationResult<T, E> {
    private final Consumer<T> onComplete;
    private final Consumer<Exception> onError;

    OperationResultBase(Consumer<T> onComplete, Consumer<Exception> onError) {
        Objects.requireNonNull(onComplete);
        Objects.requireNonNull(onError);
        this.onComplete = onComplete;
        this.onError = onError;
    }

    @Override
    public void onComplete(T result) {
        this.onComplete.accept(result);
    }

    @Override
    public void onError(E error) {
        this.onError.accept((Exception)error);
    }
}

