/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.LogicalDatabaseMetaData;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection
implements Connection {
    ClientConnection physicalConnection_;
    private ClientPooledConnection pooledConnection_ = null;
    private LogicalDatabaseMetaData logicalDatabaseMetaData = null;

    public LogicalConnection(ClientConnection physicalConnection, ClientPooledConnection pooledConnection) throws SqlException {
        this.physicalConnection_ = physicalConnection;
        this.pooledConnection_ = pooledConnection;
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void nullPhysicalConnection() {
        this.physicalConnection_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ClientPooledConnection clientPooledConnection = this.pooledConnection_;
        synchronized (clientPooledConnection) {
            LogicalConnection logicalConnection = this;
            synchronized (logicalConnection) {
                try {
                    if (this.physicalConnection_ == null) {
                        return;
                    }
                    if (this.physicalConnection_.agent_.loggingEnabled()) {
                        this.physicalConnection_.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                    }
                    if (this.physicalConnection_.isClosed()) {
                        this.pooledConnection_.informListeners(new SqlException(null, new ClientMessageId("08003.C.3"), new Object[0]));
                    } else {
                        this.physicalConnection_.checkForTransactionInProgress();
                        this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
                        if (!this.physicalConnection_.isGlobalPending_()) {
                            this.pooledConnection_.recycleConnection();
                        }
                    }
                    this.physicalConnection_ = null;
                    this.pooledConnection_.nullLogicalConnection();
                }
                catch (SqlException se) {
                    throw se.getSQLException();
                }
            }
        }
    }

    public synchronized void closeWithoutRecyclingToPool() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        this.physicalConnection_.checkForTransactionInProgress();
        try {
            if (this.physicalConnection_.isClosed()) {
                throw new SqlException(null, new ClientMessageId("08003"), new Object[0]);
            }
        }
        finally {
            this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
            this.physicalConnection_ = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.physicalConnection_ == null) {
            return true;
        }
        return this.physicalConnection_.isClosed();
    }

    protected final void checkForNullPhysicalConnection() throws SQLException {
        if (this.physicalConnection_ == null) {
            SqlException se = new SqlException(null, new ClientMessageId("08003"), new Object[0]);
            throw se.getSQLException();
        }
    }

    final void notifyException(SQLException sqle) {
        if (this.physicalConnection_ != null) {
            this.pooledConnection_.informListeners(new SqlException(sqle));
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.nativeSQL(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setAutoCommit(autoCommit);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.commit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTransactionIsolation(level);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            if (this.logicalDatabaseMetaData == null) {
                this.logicalDatabaseMetaData = this.newLogicalDatabaseMetaData();
            }
            return this.logicalDatabaseMetaData;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    protected LogicalDatabaseMetaData newLogicalDatabaseMetaData() throws SQLException {
        return new LogicalDatabaseMetaData(this, this.physicalConnection_.agent_.logWriter_);
    }

    final synchronized DatabaseMetaData getRealMetaDataObject() throws SQLException {
        if (this.isClosed()) {
            throw new SqlException(this.physicalConnection_ == null ? null : this.physicalConnection_.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]).getSQLException();
        }
        return this.physicalConnection_.getMetaData();
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setReadOnly(readOnly);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setHoldability(holdability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint(name);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public int getTransactionID() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getTransactionID();
    }

    public int getServerVersion() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getServerVersion();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createArrayOf(typeName, elements);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createBlob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createNClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createSQLXML();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStruct(typeName, attributes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo(name);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        try {
            if (this.physicalConnection_ == null) {
                return false;
            }
            return this.physicalConnection_.isValid(timeout);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return interfaces.isInstance(this);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(properties);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw new SQLClientInfoException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(name, value);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw new SQLClientInfoException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(name, value)).getProperties());
        }
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            try {
                return interfaces.cast(this);
            }
            catch (ClassCastException cce) {
                throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
            }
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getSchema();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized void setSchema(String schemaName) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setSchema(schemaName);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            if (this.physicalConnection_ != null) {
                this.physicalConnection_.abort(executor);
            }
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getNetworkTimeout();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }
}

