/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.format;

import io.vertx.codegen.format.Case;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CamelCase
extends Case {
    public static final Case INSTANCE = new CamelCase();

    @Override
    public String name() {
        return "CAMEL";
    }

    @Override
    public String format(Iterable<String> atoms) {
        StringBuilder sb = new StringBuilder();
        for (String atom : atoms) {
            if (atom.length() <= 0) continue;
            char c = atom.charAt(0);
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                sb.append(atom, 1, atom.length());
                continue;
            }
            sb.append(atom);
        }
        return sb.toString();
    }

    @Override
    public List<String> parse(String name) {
        String[] atoms = name.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        if (atoms.length == 1 && atoms[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(atoms);
    }
}

