/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.Map;
import org.keycloak.broker.provider.mappersync.ConfigSynchronizer;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleConfigPropertyByRoleNameSynchronizer
implements ConfigSynchronizer<RoleModel.RoleNameChangeEvent> {
    public static final RoleConfigPropertyByRoleNameSynchronizer INSTANCE = new RoleConfigPropertyByRoleNameSynchronizer();

    private RoleConfigPropertyByRoleNameSynchronizer() {
    }

    @Override
    public Class<RoleModel.RoleNameChangeEvent> getEventClass() {
        return RoleModel.RoleNameChangeEvent.class;
    }

    @Override
    public void handleEvent(RoleModel.RoleNameChangeEvent event) {
        String currentRoleValue = KeycloakModelUtils.buildRoleQualifier(event.getClientId(), event.getPreviousName());
        event.getKeycloakSession().identityProviders().getMappersStream(Map.of("role", currentRoleValue), null, null).forEach(idpMapper -> {
            String newRoleValue = KeycloakModelUtils.buildRoleQualifier(event.getClientId(), event.getNewName());
            idpMapper.getConfig().put("role", newRoleValue);
            this.logEventProcessed("role", currentRoleValue, newRoleValue, event.getRealm().getName(), idpMapper.getName(), idpMapper.getIdentityProviderAlias());
            event.getKeycloakSession().identityProviders().updateMapper(idpMapper);
        });
    }
}

