/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.TypeVariableAsExplicitReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.inference.FirDelegatedPropertyInferenceSessionKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/TypeVariablesInExplicitReceivers;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkOtherCases", "obtainTypeVariable", "Lorg/jetbrains/kotlin/fir/types/ConeTypeVariableType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/TypeVariablesInExplicitReceivers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,879:1\n1#2:880\n*E\n"})
public final class TypeVariablesInExplicitReceivers
extends ResolutionStage {
    @NotNull
    public static final TypeVariablesInExplicitReceivers INSTANCE = new TypeVariablesInExplicitReceivers();

    private TypeVariablesInExplicitReceivers() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        if (FirDelegatedPropertyInferenceSessionKt.isAnyOfDelegateOperators(callInfo.getCallSite())) {
            return Unit.INSTANCE;
        }
        FirExpression firExpression = callInfo.getExplicitReceiver();
        if (firExpression == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        FirExpression explicitReceiver = firExpression;
        ConeTypeVariableType coneTypeVariableType = this.obtainTypeVariable(FirTypeUtilsKt.getResolvedType(explicitReceiver));
        if (coneTypeVariableType == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        ConeTypeVariableType typeVariableType = coneTypeVariableType;
        TypeParameterMarker typeParameterMarker = typeVariableType.getTypeConstructor().getOriginalTypeParameter();
        Object object = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
        if (object == null || (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) == null || (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) == null) {
            this.checkOtherCases(candidate2);
            return Unit.INSTANCE;
        }
        Object typeParameter = object;
        sink.reportDiagnostic(new TypeVariableAsExplicitReceiver(explicitReceiver, (FirTypeParameter)typeParameter));
        return Unit.INSTANCE;
    }

    private final void checkOtherCases(Candidate candidate2) {
        Object object = candidate2.chosenExtensionReceiverExpression();
        if (!((object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? this.obtainTypeVariable((ConeKotlinType)object) : null) == null)) {
            boolean $i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32 = false;
            String $i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32 = "Found TV in extension receiver of " + candidate2;
            throw new IllegalArgumentException($i$a$-require-TypeVariablesInExplicitReceivers$checkOtherCases$32.toString());
        }
        Object object2 = candidate2.dispatchReceiverExpression();
        if (!((object2 != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null ? this.obtainTypeVariable((ConeKotlinType)object2) : null) == null)) {
            boolean bl = false;
            String string2 = "Found TV in dispatch receiver of " + candidate2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final ConeTypeVariableType obtainTypeVariable(ConeKotlinType $this$obtainTypeVariable) {
        ConeTypeVariableType coneTypeVariableType;
        block9: {
            ConeKotlinType coneKotlinType = $this$obtainTypeVariable;
            if (coneKotlinType instanceof ConeFlexibleType) {
                coneTypeVariableType = this.obtainTypeVariable(((ConeFlexibleType)$this$obtainTypeVariable).getLowerBound());
            } else if (coneKotlinType instanceof ConeTypeVariableType) {
                coneTypeVariableType = (ConeTypeVariableType)$this$obtainTypeVariable;
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                coneTypeVariableType = this.obtainTypeVariable(((ConeDefinitelyNotNullType)$this$obtainTypeVariable).getOriginal());
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                for (ConeKotlinType it : (Iterable)((ConeIntersectionType)$this$obtainTypeVariable).getIntersectedTypes()) {
                    boolean bl = false;
                    ConeTypeVariableType coneTypeVariableType2 = INSTANCE.obtainTypeVariable(it);
                    if (coneTypeVariableType2 == null) continue;
                    coneTypeVariableType = coneTypeVariableType2;
                    break block9;
                }
                coneTypeVariableType = null;
            } else {
                coneTypeVariableType = null;
            }
        }
        return coneTypeVariableType;
    }
}

