/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "outerLocalClassForNested", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Map;)V", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "outerClass", "classSymbol", "outerType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classLikeType", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirOuterClassManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOuterClassManager.kt\norg/jetbrains/kotlin/fir/resolve/FirOuterClassManager\n+ 2 DeclarationUtils.kt\norg/jetbrains/kotlin/fir/resolve/DeclarationUtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,31:1\n122#2,5:32\n128#2,2:38\n131#2,2:44\n133#2:48\n38#3:37\n1782#4,4:40\n37#5,2:46\n*S KotlinDebug\n*F\n+ 1 FirOuterClassManager.kt\norg/jetbrains/kotlin/fir/resolve/FirOuterClassManager\n*L\n29#1:32,5\n29#1:38,2\n29#1:44,2\n29#1:48\n29#1:37\n29#1:40,4\n29#1:46,2\n*E\n"})
public final class FirOuterClassManager {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FirClassLikeSymbol<?>, FirClassLikeSymbol<?>> outerLocalClassForNested;
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public FirOuterClassManager(@NotNull FirSession session2, @NotNull Map<FirClassLikeSymbol<?>, ? extends FirClassLikeSymbol<?>> outerLocalClassForNested) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(outerLocalClassForNested, (String)"outerLocalClassForNested");
        this.session = session2;
        this.outerLocalClassForNested = outerLocalClassForNested;
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
    }

    @Nullable
    public final FirClassLikeSymbol<?> outerClass(@NotNull FirClassLikeSymbol<?> classSymbol) {
        Intrinsics.checkNotNullParameter(classSymbol, (String)"classSymbol");
        if (!(classSymbol instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId = ((FirClassSymbol)classSymbol).getClassId();
        if (classId.isLocal()) {
            return this.outerLocalClassForNested.get(classSymbol);
        }
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        ClassId outerClassId = classId2;
        return this.symbolProvider.getClassLikeSymbolByClassId(outerClassId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ConeClassLikeType outerType(@NotNull ConeClassLikeType classLikeType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)classLikeType, (String)"classLikeType");
        FirSession session$iv = this.session;
        boolean $i$f$outerType = false;
        ConeClassLikeType fullyExpandedType$iv = TypeExpansionUtilsKt.fullyExpandedType$default(classLikeType, session$iv, null, 2, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(fullyExpandedType$iv.getLookupTag(), session$iv);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol$iv = firClassLikeSymbol;
        if (symbol$iv instanceof FirRegularClassSymbol) {
            FirMemberDeclaration $this$isInner$iv$iv = (FirMemberDeclaration)((FirRegularClassSymbol)symbol$iv).getFir();
            boolean $i$f$isInner = false;
            if (!$this$isInner$iv$iv.getStatus().isInner()) {
                return null;
            }
        }
        FirClassLikeSymbol<?> p0 = symbol$iv;
        boolean bl = false;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = this.outerClass(p0);
        if (firClassLikeSymbol2 == null) {
            return null;
        }
        FirClassLikeSymbol<?> containingSymbol$iv = firClassLikeSymbol2;
        Object object = symbol$iv instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)symbol$iv : null;
        if (object != null && (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) != null && (object = ((FirRegularClass)object).getTypeParameters()) != null) {
            Iterable $this$count$iv$iv = (Iterable)object;
            boolean $i$f$count = false;
            if ($this$count$iv$iv instanceof Collection && ((Collection)$this$count$iv$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv$iv = 0;
                for (Object element$iv$iv : $this$count$iv$iv) {
                    FirTypeParameterRef it$iv = (FirTypeParameterRef)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof FirTypeParameter) || ++count$iv$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv$iv;
            }
        } else {
            n = 0;
        }
        int currentTypeArgumentsNumber$iv = n;
        Collection $this$toTypedArray$iv$iv = ArraysKt.drop((Object[])fullyExpandedType$iv.getTypeArguments(), (int)currentTypeArgumentsNumber$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        ConeClassLikeType coneClassLikeType = TypeConstructionUtilsKt.constructType$default(containingSymbol$iv, thisCollection$iv$iv.toArray(new ConeTypeProjection[0]), false, null, 4, null);
        return coneClassLikeType;
    }
}

