/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.Prompter;
import net.rubygrapefruit.platform.terminal.TerminalOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectView {
    private final TerminalOutput output;
    private final String prompt;
    private final List<String> options;
    private int selected;

    SelectView(TerminalOutput output, String prompt, List<String> options, int defaultOption) {
        this.output = output;
        this.prompt = prompt;
        this.options = options;
        this.selected = defaultOption;
    }

    int getSelected() {
        return this.selected;
    }

    void render() {
        this.output.newline();
        this.output.hideCursor();
        this.output.bold().write(this.prompt).write(":").normal().newline();
        for (int i = 0; i < this.options.size(); ++i) {
            this.renderItem(i);
        }
        this.output.dim().write("Use the arrow keys to select an option and press enter").normal().cursorStartOfLine();
    }

    private void renderItem(int i) {
        if (i == this.selected) {
            this.output.foreground(Prompter.SELECTION_COLOR);
            this.output.write("> ");
        } else {
            this.output.write("  ");
        }
        this.output.write(String.valueOf(i + 1)).write(") ").write(this.options.get(i));
        this.output.defaultForeground();
        this.output.newline();
    }

    void selectPrevious() {
        if (this.selected == 0) {
            return;
        }
        --this.selected;
        int rowsToMoveUp = this.options.size() - this.selected;
        this.output.cursorUp(rowsToMoveUp);
        this.renderItem(this.selected);
        this.renderItem(this.selected + 1);
        this.output.cursorDown(rowsToMoveUp - 2);
    }

    void selectNext() {
        if (this.selected == this.options.size() - 1) {
            return;
        }
        ++this.selected;
        int rowsToModeUp = this.options.size() - this.selected + 1;
        this.output.cursorUp(rowsToModeUp);
        this.renderItem(this.selected - 1);
        this.renderItem(this.selected);
        this.output.cursorDown(rowsToModeUp - 2);
    }

    void close(Integer selected) {
        this.output.clearToEndOfLine();
        for (int i = 0; i < this.options.size(); ++i) {
            this.output.cursorUp(1).clearToEndOfLine();
        }
        this.output.cursorUp(1);
        this.output.write(this.prompt).write(": ");
        if (selected != null) {
            this.output.foreground(Prompter.SELECTION_COLOR).write(this.options.get(selected)).reset();
        } else {
            this.output.write("<none>");
        }
        this.output.showCursor();
        this.output.newline();
    }
}

