/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.core;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gradle.api.Task;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.internal.cc.base.serialize.IsolateOwners;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.codecs.core.ReferenceType;
import org.gradle.internal.serialize.graph.Codec;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.gradle.internal.serialize.graph.IsolateContext;
import org.gradle.internal.serialize.graph.IsolateOwner;
import org.gradle.internal.serialize.graph.LoggingKt;
import org.gradle.internal.serialize.graph.ReadContext;
import org.gradle.internal.serialize.graph.WriteContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/gradle/internal/serialize/codecs/core/TaskReferenceCodec;", "Lorg/gradle/internal/serialize/graph/Codec;", "Lorg/gradle/api/Task;", "()V", "decode", "Lorg/gradle/internal/serialize/graph/ReadContext;", "(Lorg/gradle/internal/serialize/graph/ReadContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encode", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "value", "(Lorg/gradle/internal/serialize/graph/WriteContext;Lorg/gradle/api/Task;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isTaskReferencesAllowed", "", "core-serialization-codecs"})
@SourceDebugExtension(value={"SMAP\nTaskReferenceCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskReferenceCodec.kt\norg/gradle/internal/serialize/codecs/core/TaskReferenceCodec\n+ 2 Combinators.kt\norg/gradle/internal/serialize/graph/CombinatorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n328#2:94\n1#3:95\n*S KotlinDebug\n*F\n+ 1 TaskReferenceCodec.kt\norg/gradle/internal/serialize/codecs/core/TaskReferenceCodec\n*L\n74#1:94\n74#1:95\n*E\n"})
public final class TaskReferenceCodec
implements Codec<Task> {
    @NotNull
    public static final TaskReferenceCodec INSTANCE = new TaskReferenceCodec();

    private TaskReferenceCodec() {
    }

    @Nullable
    public Object encode(@NotNull WriteContext $this$encode, @NotNull Task value, @NotNull Continuation<? super Unit> $completion) {
        if (value == $this$encode.getIsolate().getOwner().getDelegate()) {
            CombinatorsKt.writeEnum((Encoder)((Encoder)$this$encode), (Enum)ReferenceType.SELF_REF);
        } else if (this.isTaskReferencesAllowed($this$encode, value)) {
            CombinatorsKt.writeEnum((Encoder)((Encoder)$this$encode), (Enum)ReferenceType.TASK_REF);
            $this$encode.writeString((CharSequence)value.getName());
        } else {
            CombinatorsKt.writeEnum((Encoder)((Encoder)$this$encode), (Enum)ReferenceType.PROHIBITED);
            IsolateContext isolateContext = (IsolateContext)$this$encode;
            KClass kClass = Reflection.getOrCreateKotlinClass(Task.class);
            Class clazz = GeneratedSubclasses.unpackType((Object)value);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"unpackType(value)");
            LoggingKt.logUnsupportedBaseType$default((IsolateContext)isolateContext, (String)"serialize", (KClass)kClass, (Class)clazz, (DocumentationSection)DocumentationSection.RequirementsTaskAccess, null, (int)16, null);
        }
        return Unit.INSTANCE;
    }

    private final boolean isTaskReferencesAllowed(WriteContext $this$isTaskReferencesAllowed, Task value) {
        IsolateOwner owner = $this$isTaskReferencesAllowed.getIsolate().getOwner();
        Object delegate = owner.getDelegate();
        boolean isTaskReferencesAllowed = owner instanceof IsolateOwners.OwnerTask && ((IsolateOwners.OwnerTask)owner).getAllowTaskReferences();
        boolean isTaskFromSameProject = delegate instanceof Task && Intrinsics.areEqual((Object)((Task)delegate).getProject(), (Object)value.getProject());
        return isTaskReferencesAllowed && isTaskFromSameProject;
    }

    @Nullable
    public Object decode(@NotNull ReadContext $this$decode, @NotNull Continuation<? super Task> $completion) {
        Task task;
        Decoder $this$readEnum$iv = (Decoder)$this$decode;
        boolean $i$f$readEnum = false;
        int ordinal$iv = $this$readEnum$iv.readSmallInt();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[((ReferenceType)((Enum)ReferenceType.values()[ordinal$iv])).ordinal()]) {
            case 1: {
                Object object = $this$decode.getIsolate().getOwner().getDelegate();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.api.Task");
                task = (Task)object;
                break;
            }
            case 2: {
                String taskName = $this$decode.readString();
                task = ((TaskContainerInternal)$this$decode.getIsolate().getOwner().service(TaskContainerInternal.class)).resolveTask(taskName);
                break;
            }
            case 3: {
                LoggingKt.logUnsupported$default((IsolateContext)((IsolateContext)$this$decode), (String)"deserialize", (KClass)Reflection.getOrCreateKotlinClass(Task.class), (DocumentationSection)DocumentationSection.RequirementsTaskAccess, null, (int)8, null);
                task = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return task;
    }

    @NotNull
    public String getDisplayName() {
        return Codec.DefaultImpls.getDisplayName((Codec)this);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReferenceType.values().length];
            try {
                nArray[ReferenceType.SELF_REF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceType.TASK_REF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceType.PROHIBITED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

