/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import javax.annotation.CheckForNull;
import org.gradle.api.Action;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.configuration.DefaultBuildClientMetaData;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.text.StreamingStyledTextOutputFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.launcher.bootstrap.ExecutionCompleter;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.bootstrap.ProcessCompleter;

public abstract class EntryPoint {
    private final PrintStream originalStdErr = System.err;

    public void run(String[] args) {
        RecordingExecutionListener listener = new RecordingExecutionListener();
        try {
            this.doAction(args, listener);
        }
        catch (Throwable e) {
            this.createErrorHandler().execute((Object)e);
            listener.onFailure(e);
        }
        Throwable failure = listener.getFailure();
        ExecutionCompleter completer = this.createCompleter();
        if (failure == null) {
            completer.complete();
        } else {
            completer.completeWithFailure(failure);
        }
    }

    @VisibleForTesting
    protected ExecutionCompleter createCompleter() {
        return new ProcessCompleter();
    }

    @VisibleForTesting
    protected Action<Throwable> createErrorHandler() {
        DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
        loggingConfiguration.setShowStacktrace(ShowStacktrace.ALWAYS_FULL);
        return new BuildExceptionReporter((StyledTextOutputFactory)new StreamingStyledTextOutputFactory((Appendable)this.originalStdErr), (LoggingConfiguration)loggingConfiguration, (BuildClientMetaData)new DefaultBuildClientMetaData(new GradleLauncherMetaData()));
    }

    protected abstract void doAction(String[] var1, ExecutionListener var2);

    private static class RecordingExecutionListener
    implements ExecutionListener {
        private Throwable failure;

        private RecordingExecutionListener() {
        }

        @Override
        public void onFailure(Throwable failure) {
            this.failure = failure;
        }

        @CheckForNull
        public Throwable getFailure() {
            return this.failure;
        }
    }
}

