/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.results;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.experimental.results.PrintableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultMatchers {
    @Deprecated
    public ResultMatchers() {
    }

    public static Matcher<PrintableResult> isSuccessful() {
        return ResultMatchers.failureCountIs(0);
    }

    public static Matcher<PrintableResult> failureCountIs(final int count) {
        return new TypeSafeMatcher<PrintableResult>(){

            public void describeTo(Description description) {
                description.appendText("has " + count + " failures");
            }

            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() == count;
            }
        };
    }

    public static Matcher<Object> hasSingleFailureContaining(final String string) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return item.toString().contains(string) && ResultMatchers.failureCountIs(1).matches(item);
            }

            public void describeTo(Description description) {
                description.appendText("has single failure containing " + string);
            }
        };
    }

    public static Matcher<PrintableResult> hasSingleFailureMatching(final Matcher<Throwable> matcher) {
        return new TypeSafeMatcher<PrintableResult>(){

            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() == 1 && matcher.matches((Object)item.failures().get(0).getException());
            }

            public void describeTo(Description description) {
                description.appendText("has failure with exception matching ");
                matcher.describeTo(description);
            }
        };
    }

    public static Matcher<PrintableResult> hasFailureContaining(final String string) {
        return new TypeSafeMatcher<PrintableResult>(){

            public boolean matchesSafely(PrintableResult item) {
                return item.failureCount() > 0 && item.toString().contains(string);
            }

            public void describeTo(Description description) {
                description.appendText("has failure containing " + string);
            }
        };
    }
}

