/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeDescriberRegistry;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.formatting.StyledAttributeDescriber;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class NoCompatibleVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<NoCompatibleVariantsFailure> {
    private static final String NO_MATCHING_VARIANTS_PREFIX = "No matching variant errors are explained in more detail at ";
    private static final String NO_MATCHING_VARIANTS_SECTION = "sub:variant-no-match";
    private static final String NO_VARIANTS_EXIST_PREFIX = "Creating consumable variants is explained in more detail at ";
    private static final String NO_VARIANTS_EXIST_SECTION = "sec:resolvable-consumable-configs";
    private final AttributeDescriberRegistry attributeDescribers;

    @Inject
    public NoCompatibleVariantsFailureDescriber(AttributeDescriberRegistry attributeDescribers) {
        this.attributeDescribers = attributeDescribers;
    }

    public VariantSelectionByAttributesException describeFailure(NoCompatibleVariantsFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), this.attributeDescribers.getDescribers());
        FailureSubType failureSubType = FailureSubType.determineFailureSubType(failure);
        String message = this.buildFailureMsg(new StyledAttributeDescriber(describer), failure, failureSubType);
        List<String> resolutions = this.buildResolutions(failureSubType);
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    private String buildFailureMsg(StyledAttributeDescriber describer, NoCompatibleVariantsFailure failure, FailureSubType failureSubType) {
        TreeFormatter formatter = new TreeFormatter();
        String targetVariantText = StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.describeRequestTarget());
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("Unable to find a matching variant of " + targetVariantText);
        } else {
            formatter.node("No matching variant of " + targetVariantText + " was found. The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap()) + " but:");
        }
        formatter.startChildren();
        switch (failureSubType) {
            case NO_VARIANTS_EXIST: {
                formatter.node("No variants exist.");
                break;
            }
            case NO_VARIANTS_HAVE_ATTRIBUTES: {
                formatter.node("None of the variants have attributes.");
                break;
            }
            case NO_VARIANT_MATCHES_REQUESTED_ATTRIBUTES: {
                for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
                    this.formatUnselectableVariant(candidate, formatter, describer);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown failure sub type: " + (Object)((Object)failureSubType));
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private List<String> buildResolutions(FailureSubType failureSubType) {
        if (failureSubType == FailureSubType.NO_VARIANTS_EXIST) {
            String suggestReviewCreatingConsumableConfigs = NO_VARIANTS_EXIST_PREFIX + this.getDocumentationRegistry().getDocumentationFor("declaring_dependencies", NO_VARIANTS_EXIST_SECTION) + ".";
            return this.buildResolutions(suggestReviewCreatingConsumableConfigs, this.suggestReviewAlgorithm());
        }
        return this.buildResolutions(this.suggestSpecificDocumentation(NO_MATCHING_VARIANTS_PREFIX, NO_MATCHING_VARIANTS_SECTION), this.suggestReviewAlgorithm());
    }

    private void formatUnselectableVariant(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        formatter.node("Variant '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
    }

    private static enum FailureSubType {
        NO_VARIANTS_EXIST,
        NO_VARIANTS_HAVE_ATTRIBUTES,
        NO_VARIANT_MATCHES_REQUESTED_ATTRIBUTES;


        public static FailureSubType determineFailureSubType(NoCompatibleVariantsFailure failure) {
            if (failure.getCandidates().isEmpty()) {
                return NO_VARIANTS_EXIST;
            }
            if (failure.noCandidatesHaveAttributes()) {
                return NO_VARIANTS_HAVE_ATTRIBUTES;
            }
            return NO_VARIANT_MATCHES_REQUESTED_ATTRIBUTES;
        }
    }
}

