/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;

public class DefaultLibraryBinaryIdentifier
implements LibraryBinaryIdentifier {
    private final String projectPath;
    private final String libraryName;
    private final String displayName;
    private final String variant;

    public String getDisplayName() {
        return this.displayName;
    }

    public DefaultLibraryBinaryIdentifier(String projectPath, String libraryName, String variant) {
        assert (projectPath != null) : "project path cannot be null";
        assert (libraryName != null) : "library name cannot be null";
        assert (variant != null) : "variant cannot be null";
        this.projectPath = projectPath;
        this.libraryName = libraryName;
        this.variant = variant;
        this.displayName = "project '" + projectPath + "' library '" + libraryName + "' variant '" + variant + "'";
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLibraryBinaryIdentifier that = (DefaultLibraryBinaryIdentifier)o;
        return Objects.equal((Object)this.projectPath, (Object)that.projectPath) && Objects.equal((Object)this.libraryName, (Object)that.libraryName) && Objects.equal((Object)this.variant, (Object)that.variant);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectPath, this.libraryName, this.variant});
    }

    public String toString() {
        return this.getDisplayName();
    }
}

