/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionServices;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class NoBuildDependenciesArtifactSet
implements ArtifactSet {
    private final ArtifactSet set;

    public NoBuildDependenciesArtifactSet(ArtifactSet set) {
        this.set = set;
    }

    @Override
    public ResolvedArtifactSet select(ArtifactSelectionServices consumerServices, ArtifactSelectionSpec spec) {
        ResolvedArtifactSet selectedArtifacts = this.set.select(consumerServices, spec);
        if (selectedArtifacts == ResolvedArtifactSet.EMPTY) {
            return selectedArtifacts;
        }
        return new NoDepsResolvedArtifactSet(selectedArtifacts);
    }

    private static class NoDepsResolvedArtifactSet
    implements ResolvedArtifactSet {
        private final ResolvedArtifactSet selectedArtifacts;

        public NoDepsResolvedArtifactSet(ResolvedArtifactSet selectedArtifacts) {
            this.selectedArtifacts = selectedArtifacts;
        }

        @Override
        public void visit(ResolvedArtifactSet.Visitor visitor) {
            this.selectedArtifacts.visit(visitor);
        }

        @Override
        public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
            this.selectedArtifacts.visitTransformSources(visitor);
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
            this.selectedArtifacts.visitExternalArtifacts(visitor);
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    }
}

