/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.gradle.internal.UncheckedException;

public abstract class DefaultKeyServers {
    private static final List<URI> DEFAULT_KEYSERVERS = ImmutableList.of((Object)DefaultKeyServers.uri("hkp://ha.pool.sks-keyservers.net"), (Object)DefaultKeyServers.uri("https://keyserver.ubuntu.com"), (Object)DefaultKeyServers.uri("https://keys.openpgp.org"), (Object)DefaultKeyServers.uri("https://pgp.mit.edu"));

    private static URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static List<URI> getOrDefaults(List<URI> uris) {
        if (uris.isEmpty()) {
            return DEFAULT_KEYSERVERS;
        }
        return uris;
    }
}

