/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFileCollectionVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.FailureCollectingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.logging.text.TreeFormatter;

public class ResolutionBackedFileCollection
extends AbstractFileCollection {
    private final SelectedArtifactSet artifacts;
    private final boolean lenient;
    private final ResolutionHost resolutionHost;

    public ResolutionBackedFileCollection(SelectedArtifactSet artifacts, boolean lenient, ResolutionHost resolutionHost, TaskDependencyFactory taskDependencyFactory) {
        super(taskDependencyFactory);
        this.artifacts = artifacts;
        this.lenient = lenient;
        this.resolutionHost = resolutionHost;
    }

    public ResolutionHost getResolutionHost() {
        return this.resolutionHost;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        FailureCollectingTaskDependencyResolveContext collectingContext = new FailureCollectingTaskDependencyResolveContext(context);
        this.artifacts.visitDependencies((TaskDependencyResolveContext)collectingContext);
        if (!this.lenient) {
            this.resolutionHost.consolidateFailures("dependencies", collectingContext.getFailures()).ifPresent(consolidatedFailure -> {
                this.resolutionHost.reportProblems((Throwable)((Object)consolidatedFailure));
                context.visitFailure((Throwable)((Object)consolidatedFailure));
            });
        }
    }

    public String getDisplayName() {
        return this.resolutionHost.displayName("files").getDisplayName();
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        ResolvedFileCollectionVisitor collectingVisitor = new ResolvedFileCollectionVisitor(visitor);
        this.artifacts.visitFiles(collectingVisitor, this.lenient);
        this.maybeThrowResolutionFailures(collectingVisitor);
    }

    private void maybeThrowResolutionFailures(ResolvedFileCollectionVisitor collectingVisitor) {
        if (!this.lenient) {
            this.resolutionHost.rethrowFailuresAndReportProblems("files", collectingVisitor.getFailures());
        }
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("contains: " + this.getDisplayName());
    }

    SelectedArtifactSet getArtifacts() {
        return this.artifacts;
    }
}

