/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.internal.UncheckedException;

public class GeneratedSubclasses {
    private GeneratedSubclasses() {
    }

    public static Class<?> unpack(Class<?> type) {
        if (GeneratedSubclasses.isGeneratedType(type)) {
            return GeneratedSubclasses.unpackOrFail(type);
        }
        return type;
    }

    public static boolean isGeneratedType(Class<?> type) {
        return GeneratedSubclass.class.isAssignableFrom(type);
    }

    public static Class<?> unpackOrFail(Class<?> type) {
        try {
            return (Class)type.getMethod("generatedFrom", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static Class<?> unpackType(Object object) {
        if (object instanceof GeneratedSubclass) {
            return ((GeneratedSubclass)object).publicType();
        }
        return object.getClass();
    }
}

