/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.diagnostics;

import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DaemonLogFileUtils {
    private DaemonLogFileUtils() {
    }

    static String tail(File file, int tailSize) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            EvictingQueue tailLines = lines.collect(Collectors.toCollection(() -> EvictingQueue.create((int)tailSize)));
            String string = tailLines.isEmpty() ? "<<empty>>" : String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)tailLines);
            return string;
        }
    }
}

