/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModuleBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaContentRoot;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaJavaLanguageSettings;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaLanguageLevel;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModule;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaProject;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;

public class IdeaModelBuilder
implements IdeaModelBuilderInternal {
    private final GradleProjectBuilderInternal gradleProjectBuilder;

    public IdeaModelBuilder(GradleProjectBuilderInternal gradleProjectBuilder) {
        this.gradleProjectBuilder = gradleProjectBuilder;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.idea.IdeaProject");
    }

    public DefaultIdeaProject buildAll(String modelName, Project project) {
        return this.buildForRoot(project, false);
    }

    @Override
    public DefaultIdeaProject buildForRoot(Project project, boolean offlineDependencyResolution) {
        Project root = project.getRootProject();
        this.applyIdeaPluginToBuildTree((ProjectInternal)root, new ArrayList<GradleInternal>());
        DefaultGradleProject rootGradleProject = this.gradleProjectBuilder.buildForRoot(project);
        return this.build(root, rootGradleProject, offlineDependencyResolution);
    }

    private void applyIdeaPluginToBuildTree(ProjectInternal root, List<GradleInternal> alreadyProcessed) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(IdeaPlugin.class);
        }
        for (IncludedBuildInternal reference : root.getGradle().includedBuilds()) {
            BuildState target = reference.getTarget();
            if (!(target instanceof IncludedBuildState)) continue;
            target.ensureProjectsConfigured();
            GradleInternal build = target.getMutableModel();
            if (alreadyProcessed.contains(build)) continue;
            alreadyProcessed.add(build);
            this.applyIdeaPluginToBuildTree(build.getRootProject(), alreadyProcessed);
        }
    }

    private DefaultIdeaProject build(Project project, DefaultGradleProject rootGradleProject, boolean offlineDependencyResolution) {
        IdeaModel ideaModel = this.ideaPluginFor(project).getModel();
        IdeaProject projectModel = ideaModel.getProject();
        JavaVersion projectSourceLanguageLevel = IdeaModuleBuilderSupport.convertToJavaVersion(projectModel.getLanguageLevel());
        JavaVersion projectTargetBytecodeLevel = projectModel.getTargetBytecodeVersion();
        DefaultIdeaProject out = new DefaultIdeaProject().setName(projectModel.getName()).setJdkName(projectModel.getJdkName()).setLanguageLevel((org.gradle.tooling.model.idea.IdeaLanguageLevel)new DefaultIdeaLanguageLevel(projectModel.getLanguageLevel().getLevel())).setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(projectSourceLanguageLevel).setTargetBytecodeVersion(projectTargetBytecodeLevel).setJdk(DefaultInstalledJdk.current()));
        ArrayList<DefaultIdeaModule> ideaModules = new ArrayList<DefaultIdeaModule>();
        for (IdeaModule module : projectModel.getModules()) {
            ideaModules.add(IdeaModelBuilder.createModule(module, out, rootGradleProject, offlineDependencyResolution));
        }
        out.setChildren(new LinkedList(ideaModules));
        return out;
    }

    private IdeaPlugin ideaPluginFor(Project project) {
        return (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
    }

    private static void buildDependencies(DefaultIdeaModule tapiModule, IdeaModule ideaModule, boolean offlineDependencyResolution) {
        ideaModule.setOffline(offlineDependencyResolution);
        Set<Dependency> resolved = ideaModule.resolveDependencies();
        List<DefaultIdeaDependency> dependencies = IdeaModuleBuilderSupport.buildDependencies(resolved);
        tapiModule.setDependencies(dependencies);
    }

    private static DefaultIdeaModule createModule(IdeaModule ideaModule, DefaultIdeaProject ideaProject, DefaultGradleProject rootGradleProject, boolean offlineDependencyResolution) {
        DefaultIdeaContentRoot contentRoot = IdeaModuleBuilderSupport.buildContentRoot(ideaModule);
        Project project = ideaModule.getProject();
        DefaultIdeaModule defaultIdeaModule = new DefaultIdeaModule().setName(ideaModule.getName()).setParent(ideaProject).setGradleProject(rootGradleProject.findByPath(ideaModule.getProject().getPath())).setContentRoots(Collections.singletonList(contentRoot)).setJdkName(ideaModule.getJdkName()).setCompilerOutput((IdeaCompilerOutput)IdeaModuleBuilderSupport.buildCompilerOutput(ideaModule));
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension != null) {
            IdeaLanguageLevel ideaModuleLanguageLevel = ideaModule.getLanguageLevel();
            JavaVersion moduleSourceLanguageLevel = IdeaModuleBuilderSupport.convertToJavaVersion(ideaModuleLanguageLevel);
            JavaVersion moduleTargetBytecodeVersion = ideaModule.getTargetBytecodeVersion();
            defaultIdeaModule.setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(moduleSourceLanguageLevel).setTargetBytecodeVersion(moduleTargetBytecodeVersion));
        }
        IdeaModelBuilder.buildDependencies(defaultIdeaModule, ideaModule, offlineDependencyResolution);
        return defaultIdeaModule;
    }
}

