/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.verifier;

import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.util.internal.GUtil;

public class HttpRedirectVerifierFactory {
    public static HttpRedirectVerifier create(@Nullable URI baseHost, boolean allowInsecureProtocol, Runnable insecureBaseHost, Consumer<URI> insecureRedirect) {
        Objects.requireNonNull(insecureBaseHost, "insecureBaseHost must not be null");
        Objects.requireNonNull(insecureRedirect, "insecureRedirect must not be null");
        if (allowInsecureProtocol) {
            return NoopHttpRedirectVerifier.instance;
        }
        if (baseHost != null && !GUtil.isSecureUrl((URI)baseHost)) {
            insecureBaseHost.run();
        }
        return redirectLocations -> redirectLocations.stream().filter(url -> !GUtil.isSecureUrl((URI)url)).forEach(insecureRedirect);
    }

    private static class NoopHttpRedirectVerifier
    implements HttpRedirectVerifier {
        private static NoopHttpRedirectVerifier instance = new NoopHttpRedirectVerifier();

        private NoopHttpRedirectVerifier() {
        }

        @Override
        public void validateRedirects(Collection<URI> redirectLocations) {
        }
    }
}

