/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.net.URI;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.local.FileResourceListener;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class FileResourceConnector
implements FileResourceRepository {
    private final FileSystem fileSystem;
    private final FileResourceListener listener;

    public FileResourceConnector(FileSystem fileSystem, ListenerManager listenerManager) {
        this.fileSystem = fileSystem;
        this.listener = (FileResourceListener)listenerManager.getBroadcaster(FileResourceListener.class);
    }

    @Override
    public ExternalResourceRepository withProgressLogging() {
        return this;
    }

    @Override
    public LocalBinaryResource localResource(File file) {
        return new LocalFileStandInExternalResource(file, this.fileSystem, this.listener);
    }

    @Override
    public LocallyAvailableExternalResource resource(ExternalResourceName resource, boolean revalidate) {
        return this.resource(resource);
    }

    @Override
    public LocallyAvailableExternalResource resource(ExternalResourceName location) {
        File localFile = FileResourceConnector.getFile(location);
        return new LocalFileStandInExternalResource(localFile, this.fileSystem, this.listener);
    }

    @Override
    public LocallyAvailableExternalResource resource(File file) {
        return new LocalFileStandInExternalResource(file, this.fileSystem, this.listener);
    }

    @Override
    public LocallyAvailableExternalResource resource(File file, URI originUri, ExternalResourceMetaData originMetadata) {
        return new DefaultLocallyAvailableExternalResource(originUri, file, originMetadata, this.fileSystem);
    }

    private static File getFile(ExternalResourceName location) {
        return new File(location.getUri());
    }
}

