untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZyDQvVsnQpUacQFXyh2KTMwsiGmzv94O3CjwaE+WZZFK0CiQ7KTTtwWms3gSZQHzOjYtBT8sLJvqImlHVSw1MQA=

OpenBSD 7.0 errata 011, January 24, 2022:

On PowerPC kernel memory is leaked to userland.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 011_ppctrap.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/powerpc/powerpc/trap.c
===================================================================
RCS file: /cvs/src/sys/arch/powerpc/powerpc/trap.c,v
diff -u -p -r1.121 trap.c
--- sys/arch/powerpc/powerpc/trap.c	20 May 2021 12:34:35 -0000	1.121
+++ sys/arch/powerpc/powerpc/trap.c	21 Jan 2022 14:22:39 -0000
@@ -154,7 +154,7 @@ void
 enable_vec(struct proc *p)
 {
 	struct pcb *pcb = &p->p_addr->u_pcb;
-	struct vreg *pcb_vr = pcb->pcb_vr;
+	struct vreg *pcb_vr;
 	struct cpu_info *ci = curcpu();
 	u_int32_t oldmsr, msr;
 
@@ -163,6 +163,7 @@ enable_vec(struct proc *p)
 	 */
 	if (pcb->pcb_vr == NULL)
 		pcb->pcb_vr = pool_get(&ppc_vecpl, PR_WAITOK | PR_ZERO);
+	pcb_vr = pcb->pcb_vr;
 
 	if (curcpu()->ci_vecproc != NULL || pcb->pcb_veccpu != NULL)
 		printf("attempting to restore vector in use vecproc %p"
@@ -422,10 +423,10 @@ trap(struct trapframe *frame)
 			/* nothing to do */
 			break;
 		default:
+			frame->fixreg[FIRSTARG + 1] = rval[1];
 		bad:
 			frame->fixreg[0] = error;
 			frame->fixreg[FIRSTARG] = error;
-			frame->fixreg[FIRSTARG + 1] = rval[1];
 			frame->cr |= 0x10000000;
 			break;
 		}
