untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEnCNqRgNEsANV+DEkdi+3XdFq3ZXbbYw0aONb8Yjh2AD6nL3/2nxdqcbwiUJ2sTGmO9LrpsYSYKQnFCVxqBwcww=

OpenBSD 6.1 errata 023, August 3, 2017:

An integer overflow in wsdisplay_cfg_ioctl() may result in
an out-of-bounds read.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 023_wsdisplay.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/wscons/wsdisplay.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsdisplay.c,v
--- sys/dev/wscons/wsdisplay.c	11 Jan 2017 08:21:33 -0000	1.126
+++ sys/dev/wscons/wsdisplay.c	18 Jul 2017 21:27:50 -0000	1.127
@@ -1304,6 +1304,10 @@ wsdisplay_cfg_ioctl(struct wsdisplay_sof
 	case WSDISPLAYIO_LDFONT:
 #define d ((struct wsdisplay_font *)data)
 		if (!sc->sc_accessops->load_font)
+			return (EINVAL);
+		if (d->fontheight > 64 || d->stride > 8) /* 64x64 pixels */
+			return (EINVAL);
+		if (d->numchars > 65536) /* unicode plane */
 			return (EINVAL);
 		fontsz = d->fontheight * d->stride * d->numchars;
 		if (fontsz > WSDISPLAY_MAXFONTSZ)
