/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.TabbedType;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public class NBTabbedPane
extends JTabbedPane {
    private final WinsysInfoForTabbedContainer winsysInfo;
    private final TabDataModel dataModel;
    protected final TabbedType type;
    private transient List<ActionListener> actionListenerList;
    private boolean active;
    private ComponentConverter converter;
    private int _tabIndex;
    private Color _background;
    private Color _foreground;
    private Color _savedBackground;
    private Color _savedForeground;
    private int count;
    private int blinks = 3;
    private Timer timer = new Timer(1000, new ActionListener(){
        private boolean on = false;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NBTabbedPane.this.count = 0;
            NBTabbedPane.this.blink(this.on);
            this.on = !this.on;
        }
    });

    public NBTabbedPane(TabDataModel tabDataModel, TabbedType tabbedType, WinsysInfoForTabbedContainer winsysInfoForTabbedContainer) {
        switch (tabbedType) {
            case VIEW: 
            case EDITOR: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported UI type: " + tabbedType);
            }
        }
        if (tabDataModel == null) {
            tabDataModel = new DefaultTabDataModel();
        }
        this.dataModel = tabDataModel;
        this.type = tabbedType;
        this.winsysInfo = winsysInfoForTabbedContainer;
        this.updateUI();
        this.setFocusable(false);
    }

    public WinsysInfoForTabbedContainer getWinsysInfoForTabbedContainer() {
        return this.winsysInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postActionEvent(TabActionEvent tabActionEvent) {
        List<ActionListener> list;
        NBTabbedPane nBTabbedPane = this;
        synchronized (nBTabbedPane) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (ActionListener actionListener : list) {
            actionListener.actionPerformed((ActionEvent)tabActionEvent);
        }
    }

    public final TabbedType getType() {
        return this.type;
    }

    public int indexOf(Component component) {
        if (null == component) {
            return -1;
        }
        return this.indexOfComponent(component);
    }

    public final ComponentConverter getComponentConverter() {
        if (this.converter != null) {
            return this.converter;
        }
        return ComponentConverter.DEFAULT;
    }

    public final void setComponentConverter(ComponentConverter componentConverter) {
        List list;
        ComponentConverter componentConverter2 = this.converter;
        this.converter = componentConverter;
        if (componentConverter2 instanceof ComponentConverter.Fixed && componentConverter instanceof ComponentConverter.Fixed && !(list = this.getDataModel().getTabs()).isEmpty()) {
            TabData[] tabDataArray = list.toArray(new TabData[0]);
            this.getDataModel().setTabs(new TabData[0]);
            this.getDataModel().setTabs(tabDataArray);
        }
    }

    public final synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList<ActionListener>();
        }
        this.actionListenerList.add(actionListener);
    }

    public final synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
            if (this.actionListenerList.isEmpty()) {
                this.actionListenerList = null;
            }
        }
    }

    public TabDataModel getDataModel() {
        return this.dataModel;
    }

    public int dropIndexOfPoint(Point point) {
        int n = this.indexAtLocation(point.x, point.y);
        if (n < 0) {
            n = this.getTabCount();
        } else if (n == this.getTabCount() - 1) {
            Rectangle rectangle = this.getBoundsAt(n);
            if (this.getTabPlacement() == 1 || this.getTabPlacement() == 3) {
                if (point.x > rectangle.x + rectangle.width / 2) {
                    ++n;
                }
            } else if (point.y > rectangle.y + rectangle.height / 2) {
                ++n;
            }
        }
        return n;
    }

    public final void requestAttention(int n) {
        this.startBlinking(n, Color.RED, Color.BLUE);
    }

    public final void cancelRequestAttention(int n) {
        this.stopBlinking();
    }

    public final void setAttentionHighlight(int n, boolean bl) {
    }

    public final void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
            this.firePropertyChange("active", !bl, bl);
        }
    }

    public int tabForCoordinate(Point point) {
        return this.indexAtLocation(point.x, point.y);
    }

    public Image createImageOfTab(int n) {
        TabData tabData = this.getDataModel().getTab(n);
        JLabel jLabel = new JLabel(tabData.getText());
        int n2 = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(tabData.getText());
        int n3 = jLabel.getFontMetrics(jLabel.getFont()).getHeight();
        n2 = n2 + tabData.getIcon().getIconWidth() + 6;
        n3 = Math.max(n3, tabData.getIcon().getIconHeight()) + 5;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(jLabel.getForeground());
        graphics2D.setFont(jLabel.getFont());
        tabData.getIcon().paintIcon(jLabel, graphics2D, 0, 0);
        graphics2D.drawString(tabData.getText(), 18, n3 / 2);
        return bufferedImage;
    }

    public void startBlinking(int n, Color color, Color color2) {
        this._tabIndex = n;
        this._savedForeground = this.getForeground();
        this._savedBackground = this.getBackground();
        this._foreground = color;
        this._background = color2;
        this.timer.start();
    }

    private void blink(boolean bl) {
        if (this.count >= this.blinks) {
            this.stopBlinking();
        }
        ++this.count;
        if (bl) {
            if (this._foreground != null) {
                this.setForegroundAt(this._tabIndex, this._foreground);
            }
            if (this._background != null) {
                this.setBackgroundAt(this._tabIndex, this._background);
            }
        } else {
            if (this._savedForeground != null) {
                this.setForegroundAt(this._tabIndex, this._savedForeground);
            }
            if (this._savedBackground != null) {
                this.setBackgroundAt(this._tabIndex, this._savedBackground);
            }
        }
        this.repaint();
    }

    public void stopBlinking() {
        this.timer.stop();
        this.setForegroundAt(this._tabIndex, this._savedForeground);
        this.setBackgroundAt(this._tabIndex, this._savedBackground);
    }
}

