/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorRunnable;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThreadedServerWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private ServerSocket serverSocket;
    private Socket socket;
    private final int port;
    private Thread currentThread;
    List<Socket> sockets = new ArrayList<Socket>();
    private final int poolSize = 3;
    private boolean killed = true;
    private boolean shutdown = true;
    private final ExecutorService pool;

    public ThreadedServerWorkflowExecutor(State state) {
        super(WorkflowExecutorType.THREADED_SERVER, state);
        this.port = this.config.getDefaultServerConnection().getPort();
        this.pool = Executors.newFixedThreadPool(3);
        this.addHook();
    }

    public void addHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("Received shutdown signal, shutting down server.");
                ThreadedServerWorkflowExecutor.this.kill();
                LOGGER.info("Waiting for connections to be closed...");
                for (int watchDog = 3; !ThreadedServerWorkflowExecutor.this.shutdown && watchDog > 0; --watchDog) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Problem while waiting, could not sleep");
                    }
                }
                if (!ThreadedServerWorkflowExecutor.this.shutdown) {
                    LOGGER.debug("Forcing sockets to close");
                    ThreadedServerWorkflowExecutor.this.closeSockets();
                    ThreadedServerWorkflowExecutor.this.shutdownAndAwaitTermination();
                }
                LOGGER.debug("Server shutdown complete.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        ThreadedServerWorkflowExecutor threadedServerWorkflowExecutor = this;
        synchronized (threadedServerWorkflowExecutor) {
            this.currentThread = Thread.currentThread();
        }
        LOGGER.info("Listening on port " + this.port + "...");
        LOGGER.info("--- use SIGINT to shutdown ---");
        this.initialize();
        try {
            while (!this.killed) {
                this.socket = this.serverSocket.accept();
                this.pool.execute(new WorkflowExecutorRunnable(this.state, this.socket));
                this.sockets.add(this.socket);
            }
        }
        catch (IOException ex) {
            if (!this.killed) {
                throw new RuntimeException("Failed to accept connection");
            }
        }
        finally {
            this.closeSockets();
            this.shutdownAndAwaitTermination();
            this.shutdown = true;
            LOGGER.info("Server shutdown cleanly");
        }
    }

    public void initialize() {
        LOGGER.info("Initializing server connection end at port " + this.port);
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            LOGGER.debug("Server socket already initialized");
            return;
        }
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.serverSocket.setReuseAddress(true);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not instantiate server socket");
        }
        this.killed = false;
        this.shutdown = false;
    }

    public void kill() {
        this.killed = true;
    }

    public synchronized void closeSockets() {
        for (Socket s : this.sockets) {
            LOGGER.debug("Closing socket " + this.socket);
            try {
                if (s != null) {
                    s.close();
                    s = null;
                    continue;
                }
                LOGGER.debug("... already closed.");
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to close socket " + this.socket);
            }
        }
        try {
            LOGGER.debug("Closing server socket ");
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to close server socket.");
        }
        LOGGER.info("All sockets closed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shutdownAndAwaitTermination() {
        this.pool.shutdown();
        try {
            if (this.pool.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.pool.shutdownNow();
            if (this.pool.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

