/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.serializer.Serializer;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionTicketSerializer
extends Serializer<SessionTicket> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SessionTicket sessionTicket;

    public SessionTicketSerializer(SessionTicket sessionTicket) {
        this.sessionTicket = sessionTicket;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing SessionTicket");
        this.writeKeyName(this.sessionTicket);
        this.writeIV(this.sessionTicket);
        this.writeEncryptedState(this.sessionTicket);
        this.writeMAC(this.sessionTicket);
        return this.getAlreadySerialized();
    }

    private void writeKeyName(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getKeyName().getValue());
        LOGGER.debug("KeyName: " + ArrayConverter.bytesToHexString((byte[])((byte[])sessionTicket.getKeyName().getValue())));
    }

    private void writeIV(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getIV().getValue());
        LOGGER.debug("IV: " + ArrayConverter.bytesToHexString((byte[])((byte[])sessionTicket.getIV().getValue())));
    }

    private void writeEncryptedState(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getEncryptedState().getValue());
        LOGGER.debug("EncryptedState: " + ArrayConverter.bytesToHexString((byte[])((byte[])sessionTicket.getEncryptedState().getValue()), (boolean)true, (boolean)true));
    }

    private void writeMAC(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getMAC().getValue());
        LOGGER.debug("MAC: " + ArrayConverter.bytesToHexString((byte[])((byte[])sessionTicket.getMAC().getValue())));
    }
}

