/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TextHelpModel;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;
import javax.help.plaf.HelpUI;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JHelp
extends JComponent
implements HelpSetListener,
Accessible {
    protected TextHelpModel helpModel;
    protected Vector navigators = new Vector();
    protected boolean navDisplayed = true;
    protected JHelpContentViewer contentViewer;
    private boolean debug = false;

    static {
        HelpUtilities.installLookAndFeelDefaults();
    }

    public JHelp() {
        this((TextHelpModel)null);
    }

    public JHelp(HelpSet helpSet) {
        this(new DefaultHelpModel(helpSet));
    }

    public JHelp(TextHelpModel textHelpModel) {
        this.contentViewer = new JHelpContentViewer(textHelpModel);
        this.setModel(textHelpModel);
        this.updateUI();
        if (textHelpModel != null) {
            this.setupNavigators();
        }
    }

    public void addHelpNavigator(JHelpNavigator jHelpNavigator) {
        this.debug("addHelpNavigator(" + jHelpNavigator + ")");
        this.navigators.addElement(jHelpNavigator);
        HelpUI helpUI = this.getUI();
        helpUI.addNavigator(jHelpNavigator);
        jHelpNavigator.setModel(this.getModel());
    }

    private void addHelpSet(HelpSet helpSet) {
        NavigatorView[] navigatorViewArray = helpSet.getNavigatorViews();
        int n = 0;
        while (n < navigatorViewArray.length) {
            String string = navigatorViewArray[n].getName();
            this.debug("addHelpSet: looking for navigator for " + string);
            JHelpNavigator jHelpNavigator = this.findNavigator(string);
            if (jHelpNavigator != null) {
                this.debug("   found");
                if (jHelpNavigator.canMerge(navigatorViewArray[n])) {
                    this.debug("  canMerge: true; merging...");
                    jHelpNavigator.merge(navigatorViewArray[n]);
                } else {
                    this.debug("  canMerge: false");
                }
            } else {
                this.debug("   not found");
            }
            ++n;
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("JHelp: " + string);
        }
    }

    private JHelpNavigator findNavigator(String string) {
        this.debug("findNavigator(" + string + ")");
        Enumeration enumeration = this.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            this.debug("  nav: " + jHelpNavigator);
            this.debug("  nav.getName: " + jHelpNavigator.getNavigatorName());
            if (!jHelpNavigator.getNavigatorName().equals(string)) continue;
            return jHelpNavigator;
        }
        return null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJHelp();
        }
        return this.accessibleContext;
    }

    public JHelpContentViewer getContentViewer() {
        return this.contentViewer;
    }

    public JHelpNavigator getCurrentNavigator() {
        HelpUI helpUI = this.getUI();
        return helpUI.getCurrentNavigator();
    }

    public Enumeration getHelpNavigators() {
        return this.navigators.elements();
    }

    public URL getHelpSetURL() {
        HelpSet helpSet = this.contentViewer.getModel().getHelpSet();
        if (helpSet == null) {
            return null;
        }
        return helpSet.getHelpSetURL();
    }

    public TextHelpModel getModel() {
        return this.helpModel;
    }

    public HelpUI getUI() {
        return (HelpUI)this.ui;
    }

    public String getUIClassID() {
        return "HelpUI";
    }

    public void helpSetAdded(HelpSetEvent helpSetEvent) {
        this.debug("helpSetAdded(" + helpSetEvent + ")");
        HelpSet helpSet = helpSetEvent.getHelpSet();
        this.addHelpSet(helpSet);
    }

    public void helpSetRemoved(HelpSetEvent helpSetEvent) {
        this.debug("helpSetRemoved(" + helpSetEvent + ")");
        HelpSet helpSet = helpSetEvent.getHelpSet();
        this.removeHelpSet(helpSet);
    }

    public boolean isNavigatorDisplayed() {
        return this.navDisplayed;
    }

    public void removeHelpNavigator(JHelpNavigator jHelpNavigator) {
        this.debug("removeHelpNavigator(" + jHelpNavigator + ")");
        if (jHelpNavigator == null) {
            throw new NullPointerException("navigator");
        }
        this.navigators.removeElement(jHelpNavigator);
        HelpUI helpUI = this.getUI();
        helpUI.removeNavigator(jHelpNavigator);
    }

    private void removeHelpSet(HelpSet helpSet) {
        NavigatorView[] navigatorViewArray = helpSet.getNavigatorViews();
        int n = 0;
        while (n < navigatorViewArray.length) {
            String string = navigatorViewArray[n].getName();
            this.debug("addHelpSet: looking for navigator for " + string);
            JHelpNavigator jHelpNavigator = this.findNavigator(string);
            if (jHelpNavigator != null) {
                this.debug("   found");
                if (jHelpNavigator.canMerge(navigatorViewArray[n])) {
                    this.debug("  canMerge: true; removing...");
                    jHelpNavigator.remove(navigatorViewArray[n]);
                } else {
                    this.debug("  canMerge: false");
                }
            } else {
                this.debug("   not found");
            }
            ++n;
        }
    }

    public void setCurrentID(String string) throws BadIDException {
        try {
            this.helpModel.setCurrentID(Map.ID.create(string, this.getModel().getHelpSet()));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {}
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        if (this.helpModel != null) {
            this.helpModel.setCurrentID(iD);
        }
    }

    public void setCurrentNavigator(JHelpNavigator jHelpNavigator) {
        HelpUI helpUI = this.getUI();
        helpUI.setCurrentNavigator(jHelpNavigator);
    }

    public void setCurrentURL(URL uRL) {
        this.helpModel.setCurrentURL(uRL);
    }

    public void setHelpSetSpec(String string) {
        HelpSet helpSet;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            URL uRL = new URL(string);
            helpSet = new HelpSet(classLoader, uRL);
        }
        catch (Exception exception) {
            System.err.println("Trouble setting HelpSetSpec to spec |" + string + "|");
            System.err.println("  ex: " + exception);
            helpSet = null;
        }
        this.contentViewer.setModel(new DefaultHelpModel(helpSet));
        this.setModel(this.contentViewer.getModel());
        this.updateUI();
    }

    public void setModel(TextHelpModel textHelpModel) {
        TextHelpModel textHelpModel2 = this.helpModel;
        if (textHelpModel != textHelpModel2) {
            Object object;
            if (textHelpModel2 != null) {
                textHelpModel2.getHelpSet().removeHelpSetListener(this);
            }
            this.helpModel = textHelpModel;
            if (textHelpModel != null && (object = textHelpModel.getHelpSet()) != null) {
                ((HelpSet)object).addHelpSetListener(this);
            }
            this.firePropertyChange("helpModel", textHelpModel2, this.helpModel);
            this.contentViewer.setModel(textHelpModel);
            object = this.getUI();
            if (object == null) {
                return;
            }
            Enumeration enumeration = this.getHelpNavigators();
            while (enumeration.hasMoreElements()) {
                JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
                ((HelpUI)object).removeNavigator(jHelpNavigator);
            }
            this.navigators.removeAllElements();
            this.setupNavigators();
            this.invalidate();
        }
    }

    public void setNavigatorDisplayed(boolean bl) {
        if (this.navDisplayed != bl) {
            this.navDisplayed = bl;
            this.firePropertyChange("navigatorDisplayed", bl ^ true, bl);
        }
    }

    public void setUI(HelpUI helpUI) {
        if ((HelpUI)this.ui != helpUI) {
            super.setUI(helpUI);
            this.repaint();
        }
    }

    protected void setupNavigators() {
        Object object;
        HelpSet helpSet = this.helpModel.getHelpSet();
        if (helpSet == null) {
            return;
        }
        NavigatorView[] navigatorViewArray = helpSet.getNavigatorViews();
        this.debug("views: " + navigatorViewArray);
        Object object2 = null;
        int n = 0;
        while (n < navigatorViewArray.length) {
            this.debug("  processing info: " + navigatorViewArray[n]);
            object = (JHelpNavigator)navigatorViewArray[n].createNavigator(this.helpModel);
            if (object == null) {
                System.err.println("no JHelpNavigator for given info");
            } else {
                this.debug("  adding the navigator");
                this.navigators.addElement(object);
                this.getUI().addNavigator((JHelpNavigator)object);
                if (object2 == null) {
                    object2 = object;
                }
            }
            ++n;
        }
        this.debug("setting the current Navigator");
        if (object2 != null) {
            this.setCurrentNavigator((JHelpNavigator)object2);
        }
        object = helpSet.getHelpSets();
        while (object.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)object.nextElement();
            this.addHelpSet(helpSet2);
        }
    }

    public void updateUI() {
        this.setUI((HelpUI)UIManager.getUI(this));
        this.invalidate();
    }

    protected class AccessibleJHelp
    extends JComponent.AccessibleJComponent {
        protected AccessibleJHelp() {
            super(JHelp.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

