/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec3(-2.0, -2.0, -2.0), vec3(-3.0, -3.0, -3.0), vec3(0.0, 0.33333334, 0.6666667)) => vec3(-2.0, -2.3333333, -2.6666667)
 * mix(vec3(-2.0, -2.0, -2.0), vec3(-3.0, 3.0, 3.0), vec3(1.0, 0.0, 0.33333334)) => vec3(-3.0, -2.0, -0.33333328)
 * mix(vec3(-2.0, -2.0, 2.0), vec3(3.0, 3.0, -3.0), vec3(0.6666667, 1.0, 0.0)) => vec3(1.3333335, 3.0, 2.0)
 * mix(vec3(2.0, 2.0, 2.0), vec3(-3.0, -3.0, -3.0), vec3(0.33333334, 0.6666667, 1.0)) => vec3(0.33333328, -1.3333335, -3.0)
 * mix(vec3(2.0, 2.0, 2.0), vec3(3.0, 3.0, 3.0), vec3(0.0, 0.33333334, 0.6666667)) => vec3(2.0, 2.3333333, 2.6666667)
 * mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, -3.0), vec3(1.0, 0.0, 0.33333334)) => vec3(3.0, -2.0, -2.3333333)
 */
#version 120

void main()
{
  float[distance(mix(vec3(-2.0, -2.0, -2.0), vec3(-3.0, -3.0, -3.0), vec3(0.0, 0.33333334, 0.6666667)), vec3(-2.0, -2.3333333, -2.6666667)) <= 4.068852e-05 ? 1 : -1] array0;
  float[distance(mix(vec3(-2.0, -2.0, -2.0), vec3(-3.0, 3.0, 3.0), vec3(1.0, 0.0, 0.33333334)), vec3(-3.0, -2.0, -0.33333328)) <= 3.620927e-05 ? 1 : -1] array1;
  float[distance(mix(vec3(-2.0, -2.0, 2.0), vec3(3.0, 3.0, -3.0), vec3(0.6666667, 1.0, 0.0)), vec3(1.3333335, 3.0, 2.0)) <= 3.8441874e-05 ? 1 : -1] array2;
  float[distance(mix(vec3(2.0, 2.0, 2.0), vec3(-3.0, -3.0, -3.0), vec3(0.33333334, 0.6666667, 1.0)), vec3(0.33333328, -1.3333335, -3.0)) <= 3.2998316e-05 ? 1 : -1] array3;
  float[distance(mix(vec3(2.0, 2.0, 2.0), vec3(3.0, 3.0, 3.0), vec3(0.0, 0.33333334, 0.6666667)), vec3(2.0, 2.3333333, 2.6666667)) <= 4.068852e-05 ? 1 : -1] array4;
  float[distance(mix(vec3(2.0, -2.0, -2.0), vec3(3.0, -3.0, -3.0), vec3(1.0, 0.0, 0.33333334)), vec3(3.0, -2.0, -2.3333333)) <= 4.2946995e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
