/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class VerticalTextPanel
extends JPanel {
    private String text;

    public VerticalTextPanel(String text) {
        this.text = text;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int width = fm.stringWidth(this.text);
        return new Dimension(height, width);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getForeground());
        g2.rotate(-1.5707963267948966);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(this.text);
        g2.drawString(this.text, -width - 10, this.getWidth() / 2 + fm.getAscent() / 2);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

