/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollPane;
import edu.umd.cs.piccolox.swing.PViewport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

public class PDefaultScrollDirector
implements PScrollDirector,
PropertyChangeListener {
    protected PViewport viewPort;
    protected PScrollPane scrollPane;
    protected PCanvas view;
    protected PCamera camera;
    protected PRoot root;
    protected boolean scrollInProgress = false;

    public void install(PViewport pViewport, PCanvas pCanvas) {
        this.scrollPane = (PScrollPane)pViewport.getParent();
        this.viewPort = pViewport;
        this.view = pCanvas;
        if (pCanvas != null) {
            this.camera = pCanvas.getCamera();
            this.root = pCanvas.getRoot();
        }
        if (this.camera != null) {
            this.camera.addPropertyChangeListener(this);
        }
        if (this.root != null) {
            this.root.addPropertyChangeListener(this);
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void unInstall() {
        this.viewPort = null;
        this.view = null;
        if (this.camera != null) {
            this.camera.removePropertyChangeListener(this);
        }
        if (this.root != null) {
            this.root.removePropertyChangeListener(this);
        }
        this.camera = null;
        this.root = null;
    }

    public Point getViewPosition(Rectangle2D rectangle2D) {
        Point point = new Point();
        if (this.camera != null) {
            PBounds pBounds = new PBounds();
            List list = this.camera.getLayersReference();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PLayer pLayer = (PLayer)iterator.next();
                pBounds.add(pLayer.getFullBoundsReference());
            }
            this.camera.viewToLocal(pBounds);
            pBounds.add(rectangle2D);
            point.setLocation((int)(rectangle2D.getX() - pBounds.getX() + 0.5), (int)(rectangle2D.getY() - pBounds.getY() + 0.5));
        }
        return point;
    }

    public Dimension getViewSize(Rectangle2D rectangle2D) {
        Dimension dimension = new Dimension();
        if (this.camera != null) {
            PBounds pBounds = new PBounds();
            List list = this.camera.getLayersReference();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PLayer pLayer = (PLayer)iterator.next();
                pBounds.add(pLayer.getFullBoundsReference());
            }
            if (!pBounds.isEmpty()) {
                this.camera.viewToLocal(pBounds);
            }
            pBounds.add(rectangle2D);
            dimension.setSize((int)(pBounds.getWidth() + 0.5), (int)(pBounds.getHeight() + 0.5));
        }
        return dimension;
    }

    public void setViewPosition(double d, double d2) {
        if (this.camera != null && !this.scrollInProgress) {
            Cloneable cloneable;
            this.scrollInProgress = true;
            PBounds pBounds = new PBounds();
            List list = this.camera.getLayersReference();
            Object object = list.iterator();
            while (object.hasNext()) {
                cloneable = (PLayer)object.next();
                pBounds.add(cloneable.getFullBoundsReference());
            }
            object = this.camera.getViewTransform();
            ((PAffineTransform)object).transform(pBounds, pBounds);
            cloneable = this.camera.getBoundsReference();
            pBounds.add((PBounds)cloneable);
            Point2D.Double double_ = new Point2D.Double(pBounds.getX() + d, pBounds.getY() + d2);
            this.camera.localToView(double_);
            double d3 = -(((AffineTransform)object).getScaleX() * ((Point2D)double_).getX() + ((AffineTransform)object).getShearX() * ((Point2D)double_).getY());
            double d4 = -(((AffineTransform)object).getShearY() * ((Point2D)double_).getX() + ((AffineTransform)object).getScaleY() * ((Point2D)double_).getY());
            ((AffineTransform)object).setTransform(((AffineTransform)object).getScaleX(), ((AffineTransform)object).getShearY(), ((AffineTransform)object).getShearX(), ((AffineTransform)object).getScaleY(), d3, d4);
            this.camera.setViewTransform((AffineTransform)object);
            this.scrollInProgress = false;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        boolean bl2 = "viewTransform" == propertyChangeEvent.getPropertyName();
        boolean bl3 = bl = !("bounds" != propertyChangeEvent.getPropertyName() && "fullBounds" != propertyChangeEvent.getPropertyName() || propertyChangeEvent.getSource() != this.camera && propertyChangeEvent.getSource() != this.view.getRoot());
        if (bl2 || bl) {
            if (this.shouldRevalidateScrollPane()) {
                this.scrollPane.revalidate();
            } else {
                this.viewPort.fireStateChanged();
            }
        }
    }

    public boolean shouldRevalidateScrollPane() {
        if (this.camera != null) {
            if (this.scrollPane.getHorizontalScrollBarPolicy() != 30 && this.scrollPane.getVerticalScrollBarPolicy() != 20) {
                return false;
            }
            PBounds pBounds = new PBounds();
            List list = this.camera.getLayersReference();
            Object object = list.iterator();
            while (object.hasNext()) {
                PLayer pLayer = (PLayer)object.next();
                pBounds.add(pLayer.getFullBoundsReference());
            }
            this.camera.viewToLocal(pBounds);
            object = this.camera.getBoundsReference();
            pBounds.add((PBounds)object);
            int n = (int)(pBounds.getWidth() + 0.5);
            int n2 = (int)(pBounds.getHeight() + 0.5);
            int n3 = (int)(((Rectangle2D.Double)object).getWidth() + 0.5);
            int n4 = (int)(((Rectangle2D.Double)object).getHeight() + 0.5);
            if (this.scrollPane.getHorizontalScrollBar().isShowing() && n <= n3 || !this.scrollPane.getHorizontalScrollBar().isShowing() && n > n3 || this.scrollPane.getVerticalScrollBar().isShowing() && n2 <= n4 || !this.scrollPane.getVerticalScrollBar().isShowing() && n2 > n4) {
                return true;
            }
        }
        return false;
    }
}

