/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MaestroProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("@").number("(d+),").number("d+,").expression("[^,]+,").expression("([01]),").number("(d+.d+),").number("(d+),").expression("([01]),").expression("([01]),").number("(dd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(d+.?d*)").number(",(d+)").optional().any().compile();

    public MaestroProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.nextInt(0) == 1);
        position.set("battery", parser.nextDouble(0.0));
        position.set("rssi", parser.nextInt(0));
        position.set("charge", parser.nextInt(0) == 1);
        position.set("ignition", parser.nextInt(0) == 1);
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromMph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("hdop", parser.nextDouble(0.0));
        position.set("odometer", parser.nextDouble(0.0) * 1609.34);
        if (parser.hasNext()) {
            position.set("adc1", parser.nextInt(0));
        }
        return position;
    }
}

