/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 0ul, 0ul)
 * (0ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(0ul, 0ul, 0ul)
 * (3ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 0ul, 0ul)
 * (3ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(0ul, 0ul, 0ul)
 * (1192ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 14ul, 12ul)
 * (1192ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(7ul, 18ul, 6ul)
 * (1048576ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 12336ul, 11155ul)
 * (1048576ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(6278ul, 15887ul, 5607ul)
 * (4251475ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 50017ul, 45228ul)
 * (4251475ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(25457ul, 64416ul, 22735ul)
 * (29852643761ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 351207573ul, 317581316ul)
 * (29852643761ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(178758345ul, 452312784ul, 159639806ul)
 * (4398046511104ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 51741723660ul, 46787728841ul)
 * (4398046511104ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(26335607850ul, 66637068350ul, 23518965300ul)
 * (3948976685146ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 46458549237ul, 42010390267ul)
 * (3948976685146ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(23646566976ul, 59832980077ul, 21117522380ul)
 * (135763469567146206ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 1597217289025249ul, 1444292229437725ul)
 * (135763469567146206ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(812954907587701ul, 2057022266168881ul, 726007858647840ul)
 * (11654173250180970009ul / u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(8ul, 137107920590364353ul, 123980566491286914ul)
 * (11654173250180970009ul / u64vec3(167ul, 66ul, 187ul)) => u64vec3(69785468563957904ul, 176578382578499545ul, 62321782086529251ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((0ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((3ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((1192ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 14ul, 12ul))) ? 1 : -1] array4;
  float[all(equal((1192ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(7ul, 18ul, 6ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 12336ul, 11155ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(6278ul, 15887ul, 5607ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 50017ul, 45228ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(25457ul, 64416ul, 22735ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 351207573ul, 317581316ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(178758345ul, 452312784ul, 159639806ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 51741723660ul, 46787728841ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(26335607850ul, 66637068350ul, 23518965300ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 46458549237ul, 42010390267ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(23646566976ul, 59832980077ul, 21117522380ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 1597217289025249ul, 1444292229437725ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(812954907587701ul, 2057022266168881ul, 726007858647840ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul / u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(8ul, 137107920590364353ul, 123980566491286914ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul / u64vec3(167ul, 66ul, 187ul)), u64vec3(69785468563957904ul, 176578382578499545ul, 62321782086529251ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
