/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.ValidationException;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;

abstract class RegistryItems<D extends Device, S extends GENASubscription> {
    protected final RegistryImpl registry;
    protected final Set<RegistryItem<UDN, D>> deviceItems = new HashSet<RegistryItem<UDN, D>>();
    protected final Set<RegistryItem<String, S>> subscriptionItems = new HashSet<RegistryItem<String, S>>();

    RegistryItems(RegistryImpl registry) {
        this.registry = registry;
    }

    Set<RegistryItem<UDN, D>> getDeviceItems() {
        return this.deviceItems;
    }

    Set<RegistryItem<String, S>> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    abstract void add(D var1);

    abstract boolean remove(D var1);

    abstract void removeAll();

    abstract void maintain();

    abstract void shutdown();

    D get(UDN udn, boolean rootOnly) {
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Object foundDevice;
            Device device = (Device)item.getItem();
            if (((DeviceIdentity)device.getIdentity()).getUdn().equals(udn)) {
                return (D)device;
            }
            if (rootOnly || (foundDevice = ((Device)item.getItem()).findDevice(udn)) == null) continue;
            return foundDevice;
        }
        return null;
    }

    Collection<D> get(DeviceType deviceType) {
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Device[] d = ((Device)item.getItem()).findDevices(deviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(d));
        }
        return devices;
    }

    Collection<D> get(ServiceType serviceType) {
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Device[] d = ((Device)item.getItem()).findDevices(serviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(d));
        }
        return devices;
    }

    Collection<D> get() {
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            devices.add((Device)item.getItem());
        }
        return devices;
    }

    boolean contains(D device) {
        return this.contains(((DeviceIdentity)((Device)device).getIdentity()).getUdn());
    }

    boolean contains(UDN udn) {
        return this.deviceItems.contains(new RegistryItem(udn));
    }

    void addSubscription(S subscription) {
        RegistryItem<String, S> subscriptionItem = new RegistryItem<String, S>(((GENASubscription)subscription).getSubscriptionId(), subscription, ((GENASubscription)subscription).getActualDurationSeconds());
        this.subscriptionItems.add(subscriptionItem);
    }

    boolean updateSubscription(S subscription) {
        if (this.removeSubscription(subscription)) {
            this.addSubscription(subscription);
            return true;
        }
        return false;
    }

    boolean removeSubscription(S subscription) {
        return this.subscriptionItems.remove(new RegistryItem(((GENASubscription)subscription).getSubscriptionId()));
    }

    S getSubscription(String subscriptionId) {
        for (RegistryItem<String, S> registryItem : this.subscriptionItems) {
            if (!registryItem.getKey().equals(subscriptionId)) continue;
            return (S)((GENASubscription)registryItem.getItem());
        }
        return null;
    }

    Resource[] getResources(Device device) throws RegistrationException {
        UpnpServiceConfiguration config = this.registry.getConfiguration();
        if (config != null) {
            try {
                return config.getNamespace().getResources(device);
            }
            catch (ValidationException e) {
                throw new RegistrationException("Resource discover error", e);
            }
        }
        return new Resource[0];
    }
}

