/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.automation.module.script.internal.ScriptEngineFactoryHelper;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.automation.type.Output;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionParameterBuilder;
import org.openhab.core.config.core.ParameterOption;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component
public class ScriptModuleTypeProvider
extends AbstractProvider<ModuleType>
implements ModuleTypeProvider {
    private final Logger logger = LoggerFactory.getLogger(ScriptModuleTypeProvider.class);
    private final Map<String, String> parameterOptions = new TreeMap<String, String>();

    @Deactivate
    public void deactivate() {
        this.listeners.clear();
        this.parameterOptions.clear();
    }

    public @Nullable ModuleType getModuleType(String uid, @Nullable Locale locale) {
        if (this.parameterOptions.isEmpty()) {
            return null;
        }
        if ("script.ScriptAction".equals(uid)) {
            return this.getScriptActionType(locale);
        }
        if ("script.ScriptCondition".equals(uid)) {
            return this.getScriptConditionType(locale);
        }
        return null;
    }

    private ModuleType getScriptActionType(@Nullable Locale locale) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        Output result = new Output("result", "java.lang.Object", "result", "the script result", null, null, null);
        outputs.add(result);
        return new ActionType("script.ScriptAction", this.getConfigDescriptions(locale), "execute an inline script", "Allows the execution of a user-defined script.", null, Visibility.VISIBLE, null, outputs);
    }

    private ModuleType getScriptConditionType(@Nullable Locale locale) {
        return new ConditionType("script.ScriptCondition", this.getConfigDescriptions(locale), "an inline script evaluates to true", "Allows the definition of a condition through a script.", null, Visibility.VISIBLE, null);
    }

    private List<ModuleType> getModuleTypesUnconditionally(@Nullable Locale locale) {
        return List.of(this.getScriptActionType(locale), this.getScriptConditionType(locale));
    }

    private List<ConfigDescriptionParameter> getConfigDescriptions(@Nullable Locale locale) {
        ArrayList<ParameterOption> parameterOptionsList = new ArrayList<ParameterOption>();
        for (Map.Entry<String, String> entry : this.parameterOptions.entrySet()) {
            parameterOptionsList.add(new ParameterOption(entry.getKey(), entry.getValue()));
        }
        ConfigDescriptionParameter scriptType = ConfigDescriptionParameterBuilder.create((String)"type", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withMultiple(Boolean.valueOf(false)).withLabel("Script Type").withDescription("the scripting language used").withOptions(parameterOptionsList).withLimitToOptions(Boolean.valueOf(true)).build();
        ConfigDescriptionParameter script = ConfigDescriptionParameterBuilder.create((String)"script", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withReadOnly(Boolean.valueOf(false)).withMultiple(Boolean.valueOf(false)).withLabel("Script").withContext("script").withDescription("the script to execute").build();
        return List.of(scriptType, script);
    }

    public Collection<ModuleType> getModuleTypes(@Nullable Locale locale) {
        return this.parameterOptions.isEmpty() ? List.of() : this.getModuleTypesUnconditionally(locale);
    }

    public Collection<ModuleType> getAll() {
        return this.getModuleTypes(null);
    }

    private void notifyModuleTypesAdded() {
        for (ModuleType moduleType : this.getModuleTypesUnconditionally(null)) {
            this.notifyListenersAboutAddedElement(moduleType);
        }
    }

    private void notifyModuleTypesRemoved() {
        for (ModuleType moduleType : this.getModuleTypesUnconditionally(null)) {
            this.notifyListenersAboutRemovedElement(moduleType);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngineFactory(ScriptEngineFactory engineFactory) {
        Map.Entry<String, String> parameterOption = ScriptEngineFactoryHelper.getParameterOption(engineFactory);
        if (parameterOption != null) {
            boolean notifyListeners = this.parameterOptions.isEmpty();
            this.parameterOptions.put(parameterOption.getKey(), parameterOption.getValue());
            this.logger.trace("ParameterOptions: {}", this.parameterOptions);
            if (notifyListeners) {
                this.notifyModuleTypesAdded();
            }
        }
    }

    public void unsetScriptEngineFactory(ScriptEngineFactory engineFactory) {
        List<String> scriptTypes = engineFactory.getScriptTypes();
        if (!scriptTypes.isEmpty()) {
            ScriptEngine scriptEngine = engineFactory.createScriptEngine(scriptTypes.get(0));
            if (scriptEngine != null) {
                this.parameterOptions.remove(ScriptEngineFactoryHelper.getPreferredMimeType(engineFactory));
                this.logger.trace("ParameterOptions: {}", this.parameterOptions);
                if (this.parameterOptions.isEmpty()) {
                    this.notifyModuleTypesRemoved();
                }
            } else {
                this.logger.trace("unsetScriptEngineFactory: engine was null");
            }
        } else {
            this.logger.trace("unsetScriptEngineFactory: scriptTypes was empty");
        }
    }
}

