/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

public class ContainerResponseContextImpl
implements ContainerResponseContext {
    private final ResteasyReactiveRequestContext context;

    public ContainerResponseContextImpl(ResteasyReactiveRequestContext requestContext) {
        this.context = requestContext;
    }

    public int getStatus() {
        return this.response().getStatus();
    }

    protected Response response() {
        return this.context.getResponse().get();
    }

    public void setStatus(int code) {
        this.context.setResult(Response.fromResponse((Response)this.response()).status(code).build());
    }

    public Response.StatusType getStatusInfo() {
        return this.response().getStatusInfo();
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.context.setResult(Response.fromResponse((Response)this.response()).status(statusInfo).build());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.response().getHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.response().getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.response().getHeaderString(name);
    }

    public Set<String> getAllowedMethods() {
        return this.response().getAllowedMethods();
    }

    public Date getDate() {
        return this.response().getDate();
    }

    public Locale getLanguage() {
        return this.response().getLanguage();
    }

    public int getLength() {
        return this.response().getLength();
    }

    public MediaType getMediaType() {
        return this.response().getMediaType();
    }

    public Map<String, NewCookie> getCookies() {
        return this.response().getCookies();
    }

    public EntityTag getEntityTag() {
        return this.response().getEntityTag();
    }

    public Date getLastModified() {
        return this.response().getLastModified();
    }

    public URI getLocation() {
        return this.response().getLocation();
    }

    public Set<Link> getLinks() {
        return this.response().getLinks();
    }

    public boolean hasLink(String relation) {
        return this.response().hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.response().getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.response().getLinkBuilder(relation);
    }

    public boolean hasEntity() {
        return this.response().hasEntity();
    }

    public Object getEntity() {
        return this.response().getEntity();
    }

    public Class<?> getEntityClass() {
        Object entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getClass();
    }

    public Type getEntityType() {
        return this.context.getGenericReturnType();
    }

    public void setEntity(Object entity) {
        this.context.resetBuildTimeSerialization();
        if (entity instanceof GenericEntity) {
            this.context.setGenericReturnType(((GenericEntity)entity).getType());
            entity = ((GenericEntity)entity).getEntity();
        }
        Response.ResponseBuilder resp = Response.fromResponse((Response)this.response()).entity(entity);
        this.context.setResult(resp.build());
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.context.resetBuildTimeSerialization();
        if (entity instanceof GenericEntity) {
            this.context.setGenericReturnType(((GenericEntity)entity).getType());
            entity = ((GenericEntity)entity).getEntity();
        }
        this.context.setResponseContentType(mediaType);
        this.context.setAllAnnotations(annotations);
        Response.ResponseBuilder resp = Response.fromResponse((Response)this.response()).entity(entity).type(mediaType);
        this.context.setResult(resp.build());
    }

    public Annotation[] getEntityAnnotations() {
        return this.context.getAllAnnotations();
    }

    public OutputStream getEntityStream() {
        OutputStream existing = this.context.getOutputStream();
        if (existing != null) {
            return existing;
        }
        return this.context.getOrCreateOutputStream();
    }

    public void setEntityStream(OutputStream outputStream) {
        this.context.setOutputStream(outputStream);
    }
}

