/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.transformation;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.transformation.ReportTransformer;
import ca.sqlpower.sqlobject.SQLType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.AlternatorTool;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;

public class VelocityTransformation
implements ReportTransformer {
    private static Logger logger = Logger.getLogger(VelocityTransformation.class);

    @Override
    public void transform(String builtInTemplate, File result, ArchitectSwingSession session) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void transform(File template, File result, ArchitectSwingSession session) throws Exception {
        Properties props = new Properties();
        props.put("resource.loader", "file");
        props.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        props.put("file.resource.loader.path", "");
        props.put("runtime.log.logsystem.log4j.logger", logger.getName());
        VelocityEngine engine = new VelocityEngine(props);
        Template t = engine.getTemplate(template.getAbsolutePath(), "UTF-8");
        VelocityContext context = new VelocityContext();
        context.put("tables", session.getPlayPen().getTables());
        context.put("projectName", (Object)session.getName());
        context.put("sorter", (Object)new SortTool());
        context.put("dateTool", (Object)new DateTool());
        context.put("numberTool", (Object)new NumberTool());
        context.put("alternator", (Object)new AlternatorTool());
        context.put("sqlTypes", SQLType.class);
        FileOutputStream out = new FileOutputStream(result);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        try {
            t.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            logger.error((Object)"Error running Velocity template", (Throwable)e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    @Override
    public void setParameter(String name, Object value) {
    }
}

